/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common;

import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.Key;
import io.dingodb.sdk.common.PropertyDefinition;
import io.dingodb.sdk.mappers.TypeMapper;
import io.dingodb.sdk.utils.DeferredObjectLoader;
import io.dingodb.sdk.utils.ThreadLocalKeySaver;
import io.dingodb.sdk.utils.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.validation.constraints.NotNull;

public abstract class ValueType {
    private final TypeMapper mapper;
    private final TypeUtils.AnnotatedType annotatedType;

    public ValueType(@NotNull TypeMapper mapper, TypeUtils.AnnotatedType annotatedType) {
        this.mapper = mapper;
        this.annotatedType = annotatedType;
    }

    public abstract Object get(Object var1) throws ReflectiveOperationException;

    public abstract void set(Object var1, Object var2) throws ReflectiveOperationException;

    public abstract Class<?> getType();

    public abstract Annotation[] getAnnotations();

    public TypeMapper getTypeMapper() {
        return this.mapper;
    }

    public TypeUtils.AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    public static class MethodValue
    extends ValueType {
        private final PropertyDefinition property;

        public MethodValue(PropertyDefinition property, TypeMapper typeMapper, TypeUtils.AnnotatedType annotatedType) {
            super(typeMapper, annotatedType);
            this.property = property;
        }

        @Override
        public Object get(Object obj) throws ReflectiveOperationException {
            if (obj == null) {
                return null;
            }
            return this.property.getGetter().invoke(obj, new Object[0]);
        }

        @Override
        public void set(Object obj, Object value) throws ReflectiveOperationException {
            if (this.property.getSetter() == null) {
                throw new DingoClientException("Lazy loading cannot be used on objects with a property key type and no annotated key setter method");
            }
            switch (this.property.getSetterParamType()) {
                case KEY: {
                    Key key = ThreadLocalKeySaver.get();
                    if (value instanceof DeferredObjectLoader.DeferredObject) {
                        DeferredObjectLoader.DeferredSetter setter = object -> {
                            try {
                                this.property.getSetter().invoke(obj, value, key);
                            }
                            catch (ReflectiveOperationException e) {
                                throw new DingoClientException(String.format("Could not set field %s on %s to %s", this.property, obj, value));
                            }
                        };
                        DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)value);
                        DeferredObjectLoader.add(objectSetter);
                        break;
                    }
                    this.property.getSetter().invoke(obj, value, key);
                    break;
                }
                case VALUE: {
                    Key key = ThreadLocalKeySaver.get();
                    if (value instanceof DeferredObjectLoader.DeferredObject) {
                        DeferredObjectLoader.DeferredSetter setter = object -> {
                            try {
                                this.property.getSetter().invoke(obj, value, key.userKey);
                            }
                            catch (ReflectiveOperationException e) {
                                throw new DingoClientException(String.format("Could not set field %s on %s to %s", this.property, obj, value));
                            }
                        };
                        DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)value);
                        DeferredObjectLoader.add(objectSetter);
                        break;
                    }
                    this.property.getSetter().invoke(obj, value, key.userKey);
                    break;
                }
                default: {
                    if (value instanceof DeferredObjectLoader.DeferredObject) {
                        DeferredObjectLoader.DeferredSetter setter = object -> {
                            try {
                                this.property.getSetter().invoke(obj, value);
                            }
                            catch (ReflectiveOperationException e) {
                                throw new DingoClientException(String.format("Could not set field %s on %s to %s", this.property, obj, value));
                            }
                        };
                        DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)value);
                        DeferredObjectLoader.add(objectSetter);
                        break;
                    }
                    this.property.getSetter().invoke(obj, value);
                }
            }
        }

        @Override
        public Class<?> getType() {
            return this.property.getType();
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.property.getAnnotations();
        }

        public String toString() {
            return String.format("Value(Method): %s/%s (%s)", this.property.getGetter(), this.property.getSetter(), this.property.getType().getSimpleName());
        }
    }

    public static class FieldValue
    extends ValueType {
        private final Field field;

        public FieldValue(Field field, TypeMapper typeMapper, TypeUtils.AnnotatedType annotatedType) {
            super(typeMapper, annotatedType);
            this.field = field;
            this.field.setAccessible(true);
        }

        @Override
        public Object get(Object obj) throws ReflectiveOperationException {
            return this.field.get(obj);
        }

        @Override
        public void set(Object obj, Object value) throws ReflectiveOperationException {
            if (value instanceof DeferredObjectLoader.DeferredObject) {
                DeferredObjectLoader.DeferredSetter setter = object -> {
                    try {
                        this.field.set(obj, object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new DingoClientException(String.format("Could not set field %s on %s to %s", this.field, obj, value));
                    }
                };
                DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)value);
                DeferredObjectLoader.add(objectSetter);
            } else {
                this.field.set(obj, value);
            }
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.field.getAnnotations();
        }

        public String toString() {
            return String.format("Value(Field): %s (%s)", this.field.getName(), this.field.getType().getSimpleName());
        }

        public Field getField() {
            return this.field;
        }
    }
}

