/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dingodb.sdk.configuration.ColumnConfig;
import io.dingodb.sdk.configuration.KeyConfig;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;

public class ClassConfig {
    @JsonProperty(value="class")
    private String className;
    private String database;
    private String table;
    private KeyConfig key;
    private String factoryClass;
    private String factoryMethod;
    private final List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public ColumnConfig getColumnByName(@NotNull String name) {
        for (ColumnConfig thisBin : this.columns) {
            if (!name.equals(thisBin.getName())) continue;
            return thisBin;
        }
        return null;
    }

    public ColumnConfig getColumnByGetterName(@NotNull String getterName) {
        for (ColumnConfig thisBin : this.columns) {
            if (!getterName.equals(thisBin.getGetter())) continue;
            return thisBin;
        }
        return null;
    }

    public ColumnConfig getColumnByFieldName(@NotNull String fieldName) {
        for (ColumnConfig thisBin : this.columns) {
            if (!fieldName.equals(thisBin.getField())) continue;
            return thisBin;
        }
        return null;
    }

    public void validate() {
        for (ColumnConfig thisBin : this.columns) {
            thisBin.validate(this.className);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public KeyConfig getKey() {
        return this.key;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="class")
    public void setClassName(String className) {
        this.className = className;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setKey(KeyConfig key) {
        this.key = key;
    }

    public void setFactoryClass(String factoryClass) {
        this.factoryClass = factoryClass;
    }

    public void setFactoryMethod(String factoryMethod) {
        this.factoryMethod = factoryMethod;
    }
}

