/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.configuration;

import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.configuration.EmbedConfig;
import org.apache.commons.lang3.StringUtils;

public class ColumnConfig {
    private String name;
    private String field;
    private Boolean useAccessors;
    private String getter;
    private String setter;
    private Integer ordinal;
    private EmbedConfig embed;
    private Boolean exclude;

    public void validate(String className) {
        if (StringUtils.isBlank(this.name) && StringUtils.isBlank(this.field)) {
            throw new DingoClientException("Configuration for class " + className + " defines a column which contains neither a name nor a field");
        }
    }

    public String getDerivedName() {
        if (!StringUtils.isBlank(this.name)) {
            return this.name;
        }
        return this.field;
    }

    public Boolean isExclude() {
        return this.exclude;
    }

    public String getName() {
        return this.name;
    }

    public String getField() {
        return this.field;
    }

    public Boolean getUseAccessors() {
        return this.useAccessors;
    }

    public String getGetter() {
        return this.getter;
    }

    public String getSetter() {
        return this.setter;
    }

    public Integer getOrdinal() {
        return this.ordinal;
    }

    public EmbedConfig getEmbed() {
        return this.embed;
    }

    public Boolean getExclude() {
        return this.exclude;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setUseAccessors(Boolean useAccessors) {
        this.useAccessors = useAccessors;
    }

    public void setGetter(String getter) {
        this.getter = getter;
    }

    public void setSetter(String setter) {
        this.setter = setter;
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public void setEmbed(EmbedConfig embed) {
        this.embed = embed;
    }

    public void setExclude(Boolean exclude) {
        this.exclude = exclude;
    }
}

