/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.mappers;

import io.dingodb.common.operation.Value;
import io.dingodb.sdk.mappers.TypeMapper;
import io.dingodb.sdk.utils.TypeUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayMapper
extends TypeMapper {
    private final Class<?> instanceClass;
    private final boolean supportedWithoutTranslation;
    private final TypeMapper instanceClassMapper;
    private final Boolean allowBatch;

    public ArrayMapper(Class<?> instanceClass, TypeMapper instanceClassMapper, boolean allowBatch) {
        this.instanceClass = instanceClass;
        this.supportedWithoutTranslation = TypeUtils.isByteType(instanceClass);
        this.instanceClassMapper = instanceClassMapper;
        this.allowBatch = allowBatch;
    }

    @Override
    public Object toDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        int length = Array.getLength(value);
        if (this.supportedWithoutTranslation) {
            return value;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            results.add(this.instanceClassMapper.toDingoFormat(Array.get(value, i)));
        }
        return results;
    }

    @Override
    public Object fromDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        List list = null;
        list = value.getClass().isArray() ? Arrays.asList((Object[])value) : (value instanceof Value.ListValue ? (List)((Value.ListValue)value).getObject() : (List)value);
        if (this.supportedWithoutTranslation) {
            return value;
        }
        Object result = Array.newInstance(this.instanceClass, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            Object item = this.instanceClassMapper.fromDingoFormat(obj);
            Array.set(result, i, item);
        }
        return result;
    }
}

