/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.mappers;

import io.dingodb.sdk.mappers.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanMapper
extends TypeMapper {
    private static final Logger log = LoggerFactory.getLogger(BooleanMapper.class);

    @Override
    public Object toDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            if (value.toString().equalsIgnoreCase("true")) {
                return true;
            }
            if (value.toString().equalsIgnoreCase("false")) {
                return false;
            }
            try {
                return Integer.parseInt(value.toString()) != 0;
            }
            catch (NumberFormatException e) {
                log.warn("Unable to parse value {} as boolean", value);
                return false;
            }
        }
        log.error("Unsupported boolean type: " + value.getClass().getName());
        throw new IllegalArgumentException("Unsupported boolean type: " + value.getClass().getName());
    }

    @Override
    public Object fromDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        return value;
    }
}

