/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.mappers;

import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.sdk.mappers.TypeMapper;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateMapper
extends TypeMapper {
    @Override
    public Object toDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        String dateInStr = "";
        if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            dateInStr = formatter.format((Date)value);
        } else if (value instanceof java.sql.Date) {
            dateInStr = value.toString();
        } else {
            throw new IllegalArgumentException("Unsupported date type: " + value.getClass().getName());
        }
        return DateTimeUtils.parseDate(dateInStr);
    }

    @Override
    public Object fromDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        java.sql.Date expectedDate = null;
        if (value instanceof Date) {
            expectedDate = new java.sql.Date(((Date)value).getTime());
        } else if (value instanceof java.sql.Date) {
            expectedDate = (java.sql.Date)value;
        } else {
            throw new IllegalArgumentException("Unsupported date type: " + value.getClass().getName());
        }
        String dateInStr = DateTimeUtils.dateFormat(expectedDate);
        return java.sql.Date.valueOf(dateInStr);
    }
}

