/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.mappers;

import io.dingodb.sdk.mappers.TypeMapper;
import java.time.Instant;

public class InstantMapper
extends TypeMapper {
    @Override
    public Object toDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        Instant instant = (Instant)value;
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }

    @Override
    public Object fromDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        long longValue = (Long)value;
        return Instant.ofEpochSecond(longValue / 1000000000L, longValue % 1000000000L);
    }
}

