/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.mappers;

import io.dingodb.sdk.annotation.DingoEmbed;
import io.dingodb.sdk.client.IBaseDingoMapper;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.mappers.ObjectMapper;
import io.dingodb.sdk.mappers.TypeMapper;
import io.dingodb.sdk.utils.ClassCache;
import io.dingodb.sdk.utils.ClassCacheEntry;
import io.dingodb.sdk.utils.DeferredObjectLoader;
import io.dingodb.sdk.utils.TypeUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ListMapper
extends TypeMapper {
    private final Class<?> referencedClass;
    private final Class<?> instanceClass;
    private final IBaseDingoMapper mapper;
    private final boolean supportedWithoutTranslation;
    private final TypeMapper instanceClassMapper;
    private final DingoEmbed.EmbedType embedType;
    private final ClassCacheEntry<?> subTypeEntry;
    private final boolean saveKey;
    private final boolean allowBatchLoad;

    public ListMapper(Class<?> clazz, Class<?> instanceClass, TypeMapper instanceClassMapper, IBaseDingoMapper mapper, DingoEmbed.EmbedType embedType, boolean saveKey, boolean allowBatchLoad) {
        boolean isInstanceClassMapperType;
        this.referencedClass = clazz;
        this.mapper = mapper;
        this.instanceClass = instanceClass;
        this.supportedWithoutTranslation = TypeUtils.isDingoNativeType(instanceClass);
        this.instanceClassMapper = instanceClassMapper;
        this.saveKey = saveKey;
        this.allowBatchLoad = allowBatchLoad;
        this.embedType = embedType == DingoEmbed.EmbedType.DEFAULT ? DingoEmbed.EmbedType.LIST : embedType;
        boolean bl = isInstanceClassMapperType = instanceClassMapper == null || ObjectMapper.class.isAssignableFrom(instanceClassMapper.getClass());
        if (this.embedType == DingoEmbed.EmbedType.MAP && isInstanceClassMapperType) {
            this.subTypeEntry = null;
            throw new DingoClientException("Annotations embedding lists of objects can only map those objects to mapsinstead of lists if the object is an AerospikeRecord on instance of class " + clazz.getSimpleName());
        }
        this.subTypeEntry = instanceClass != null ? ClassCache.getInstance().loadClass(instanceClass, mapper) : null;
    }

    public Object toDingoInstanceFormat(Object obj) {
        if (this.embedType == null || this.embedType == DingoEmbed.EmbedType.LIST) {
            if (this.instanceClass == null) {
                if (obj == null) {
                    return null;
                }
                TypeMapper thisMapper = TypeUtils.getMapper(obj.getClass(), null, this.mapper);
                return thisMapper == null ? obj : thisMapper.toDingoFormat(obj, true, false);
            }
            if (obj == null || obj.getClass().equals(this.instanceClass)) {
                return this.instanceClassMapper.toDingoFormat(obj);
            }
            return this.instanceClassMapper.toDingoFormat(obj, false, true);
        }
        Object key = this.subTypeEntry.getKey(obj);
        Object item = obj == null || obj.getClass().equals(this.instanceClass) ? this.instanceClassMapper.toDingoFormat(obj) : this.instanceClassMapper.toDingoFormat(obj, false, true);
        return new AbstractMap.SimpleEntry<Object, Object>(key, item);
    }

    @Override
    public Object toDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        List list = (List)value;
        if (this.embedType == null || this.embedType == DingoEmbed.EmbedType.LIST) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object obj : list) {
                results.add(this.toDingoInstanceFormat(obj));
            }
            return results;
        }
        TreeMap<Object, Object> results = new TreeMap<Object, Object>();
        for (Object obj : list) {
            Object key = this.subTypeEntry.getKey(obj);
            Object item = obj == null || obj.getClass().equals(this.instanceClass) ? this.instanceClassMapper.toDingoFormat(obj) : this.instanceClassMapper.toDingoFormat(obj, false, true);
            results.put(key, item);
        }
        return results;
    }

    private Class<?> getClassToUse(Object obj) {
        if (List.class.isAssignableFrom(obj.getClass())) {
            String lastElement;
            List list = (List)obj;
            int lastElementIndex = list.size() - 1;
            if (!list.isEmpty() && list.get(lastElementIndex) instanceof String && (lastElement = (String)list.get(lastElementIndex)).startsWith("@T:")) {
                String className = lastElement.substring("@T:".length());
                ClassCacheEntry<?> thisClass = ClassCache.getInstance().getCacheEntryFromStoredName(className);
                if (thisClass != null) {
                    return thisClass.getUnderlyingClass();
                }
            }
        }
        return obj.getClass();
    }

    public Object fromDingoInstanceFormat(Object obj) {
        if (this.embedType == null || this.embedType == DingoEmbed.EmbedType.LIST) {
            if (this.instanceClass == null) {
                if (obj == null) {
                    return null;
                }
                TypeMapper thisMapper = TypeUtils.getMapper(this.getClassToUse(obj), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
                return thisMapper == null ? obj : thisMapper.fromDingoFormat(obj);
            }
            return this.instanceClassMapper.fromDingoFormat(obj);
        }
        Map.Entry entry = (Map.Entry)obj;
        Object result = this.instanceClassMapper.fromDingoFormat(entry.getValue());
        this.subTypeEntry.setKey(new Object[]{result}, new Object[]{entry.getKey()});
        return result;
    }

    @Override
    public Object fromDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        if (this.embedType == null || this.embedType == DingoEmbed.EmbedType.LIST) {
            List list = (List)value;
            if (list.size() == 0 || this.supportedWithoutTranslation) {
                return value;
            }
            int index = 0;
            if (this.instanceClass == null) {
                for (Object obj : list) {
                    if (obj == null) {
                        results.add(null);
                    } else {
                        Object result;
                        TypeMapper thisMapper = TypeUtils.getMapper(this.getClassToUse(obj), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
                        Object object2 = result = thisMapper == null ? obj : thisMapper.fromDingoFormat(obj);
                        if (result instanceof DeferredObjectLoader.DeferredObject) {
                            int thisIndex = index;
                            DeferredObjectLoader.DeferredSetter setter = object -> results.set(thisIndex, object);
                            DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)result);
                            DeferredObjectLoader.add(objectSetter);
                            results.add(null);
                        } else {
                            results.add(result);
                        }
                    }
                    ++index;
                }
            } else {
                for (Object obj : list) {
                    if (!this.allowBatchLoad) {
                        results.add(this.instanceClassMapper.fromDingoFormat(obj));
                    } else {
                        Object result = this.instanceClassMapper.fromDingoFormat(obj);
                        if (result instanceof DeferredObjectLoader.DeferredObject) {
                            int thisIndex = index;
                            DeferredObjectLoader.DeferredSetter setter = object -> results.set(thisIndex, object);
                            DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)result);
                            DeferredObjectLoader.add(objectSetter);
                            results.add(null);
                        } else {
                            results.add(result);
                        }
                    }
                    ++index;
                }
            }
        } else {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                Object item = map.get(key);
                Object result = this.instanceClassMapper.fromDingoFormat(item);
                this.subTypeEntry.setKey(new Object[]{result}, new Object[]{key});
                results.add(result);
            }
        }
        return results;
    }
}

