/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.mappers;

import io.dingodb.sdk.client.IBaseDingoMapper;
import io.dingodb.sdk.mappers.TypeMapper;
import io.dingodb.sdk.utils.DeferredObjectLoader;
import io.dingodb.sdk.utils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class MapMapper
extends TypeMapper {
    private final Class<?> referencedClass;
    private final Class<?> itemClass;
    private final Class<?> keyClass;
    private final IBaseDingoMapper mapper;
    private final boolean supportedWithoutTranslation;
    private final TypeMapper itemMapper;
    private final TypeMapper keyMapper;

    public MapMapper(Class<?> clazz, Class<?> keyClass, Class<?> itemClass, TypeMapper keyMapper, TypeMapper itemMapper, IBaseDingoMapper mapper) {
        boolean isSupportTransaction;
        this.referencedClass = clazz;
        this.mapper = mapper;
        this.keyMapper = keyMapper;
        this.keyClass = keyClass;
        this.itemMapper = itemMapper;
        this.itemClass = itemClass;
        this.supportedWithoutTranslation = isSupportTransaction = TypeUtils.isDingoNativeType(itemClass) && TypeUtils.isDingoNativeType(keyClass);
    }

    @Override
    public Object toDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        Map map = (Map)value;
        if (map.size() == 0 || this.supportedWithoutTranslation) {
            return value;
        }
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        for (Object key : map.keySet()) {
            Object item = map.get(key);
            TypeMapper mapper1 = TypeUtils.getMapper(key.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
            TypeMapper keyMap = this.keyMapper != null ? this.keyMapper : mapper1;
            TypeMapper mapper2 = TypeUtils.getMapper(item.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
            TypeMapper itemMap = this.itemMapper != null ? this.itemMapper : mapper2;
            results.put(keyMap.toDingoFormat(key), itemMap.toDingoFormat(item));
        }
        return results;
    }

    @Override
    public Object fromDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        Map map = (Map)value;
        if (map.size() == 0 || this.supportedWithoutTranslation) {
            return value;
        }
        TreeMap<Object, Object> results = new TreeMap<Object, Object>();
        for (Object key : map.keySet()) {
            Object javaItem;
            Object item = map.get(key);
            TypeMapper mapper1 = TypeUtils.getMapper(key.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
            TypeMapper keyMap = this.keyMapper != null ? this.keyMapper : mapper1;
            TypeMapper mapper2 = TypeUtils.getMapper(item.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
            TypeMapper itemMap = this.itemMapper != null ? this.itemMapper : mapper2;
            Object javaKey = keyMap == null ? null : keyMap.fromDingoFormat(key);
            Object object2 = javaItem = itemMap == null ? null : itemMap.fromDingoFormat(item);
            if (javaKey instanceof DeferredObjectLoader.DeferredObject || javaItem instanceof DeferredObjectLoader.DeferredObject) {
                DeferredObjectLoader.DeferredSetter setter = object -> results.put(javaKey, object);
                DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)javaItem);
                DeferredObjectLoader.add(objectSetter);
                continue;
            }
            results.put(javaKey, javaItem);
        }
        return results;
    }
}

