/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.mappers;

import io.dingodb.sdk.annotation.DingoEmbed;
import io.dingodb.sdk.client.IBaseDingoMapper;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.mappers.ObjectMapper;
import io.dingodb.sdk.utils.ClassCache;
import io.dingodb.sdk.utils.ClassCacheEntry;
import java.util.List;
import java.util.Map;

public class ObjectEmbedMapper
extends ObjectMapper {
    private final Class<?> referencedClass;
    private final IBaseDingoMapper mapper;
    private final DingoEmbed.EmbedType type;
    private final boolean skipKey;

    public ObjectEmbedMapper(Class<?> clazz, DingoEmbed.EmbedType type2, IBaseDingoMapper mapper, boolean skipKey) {
        this.referencedClass = clazz;
        this.mapper = mapper;
        this.type = type2;
        this.skipKey = skipKey;
    }

    @Override
    public Object toDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        boolean needsType = !this.referencedClass.equals(value.getClass());
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(value.getClass(), this.mapper);
        switch (this.type) {
            case LIST: {
                return entry.getList(value, this.skipKey, needsType);
            }
            case MAP: 
            case DEFAULT: {
                return entry.getMap(value, needsType);
            }
        }
        throw new DingoClientException("Unspecified EmbedType");
    }

    @Override
    public Object fromDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(this.referencedClass, this.mapper);
        try {
            Object instance;
            switch (this.type) {
                case LIST: {
                    List listValue = (List)value;
                    instance = entry.constructAndHydrate(listValue, this.skipKey);
                    break;
                }
                case MAP: 
                case DEFAULT: {
                    instance = entry.constructAndHydrate((Map)value);
                    break;
                }
                default: {
                    throw new DingoClientException("Unspecified EmbedType");
                }
            }
            return instance;
        }
        catch (Exception e) {
            throw new DingoClientException(e);
        }
    }
}

