/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.mappers;

import io.dingodb.common.operation.Value;
import io.dingodb.sdk.mappers.TypeMapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SetMapper
extends TypeMapper {
    private final Class<?> instanceClass;
    private final TypeMapper instanceClassMapper;

    public SetMapper(Class<?> instanceClass, TypeMapper instanceClassMapper) {
        this.instanceClass = instanceClass;
        this.instanceClassMapper = instanceClassMapper;
    }

    @Override
    public Object toDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        Object[] array = ((HashSet)value).toArray();
        int length = Array.getLength(array);
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            results.add(this.instanceClassMapper.toDingoFormat(Array.get(array, i)));
        }
        return results;
    }

    @Override
    public Object fromDingoFormat(Object value) {
        if (value == null) {
            return null;
        }
        List<Object> list = null;
        if (value.getClass().isArray()) {
            System.out.println("huzx: set is array1 " + value.getClass().getComponentType());
            list = Arrays.asList((Object[])value);
        } else if (value instanceof Value.ListValue) {
            list = (List)((Value.ListValue)value).getObject();
            System.out.println("huzx: set is array2 " + value.getClass().toGenericString());
        } else {
            list = (List<Object>)value;
        }
        HashSet<Object> result = new HashSet<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Object item = this.instanceClassMapper.fromDingoFormat(list.get(i));
            result.add(item);
        }
        return result;
    }
}

