/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.operation;

import io.dingodb.common.operation.Operation;
import io.dingodb.common.operation.filter.DingoFilter;
import io.dingodb.sdk.common.Key;
import io.dingodb.sdk.common.Record;
import io.dingodb.sdk.operation.UDFContext;
import java.util.List;

public final class ContextForClient {
    private final List<Key> startKeyList;
    private final List<Key> endKeyList;
    private final List<Record> recordList;
    private final List<Operation> operationList;
    private final UDFContext udfContext;
    private final DingoFilter filter;
    private final boolean skippedWhenExisted;

    public static ContextForClientBuilder builder() {
        return new ContextForClientBuilder();
    }

    public List<Key> getStartKeyList() {
        return this.startKeyList;
    }

    public List<Key> getEndKeyList() {
        return this.endKeyList;
    }

    public List<Record> getRecordList() {
        return this.recordList;
    }

    public List<Operation> getOperationList() {
        return this.operationList;
    }

    public UDFContext getUdfContext() {
        return this.udfContext;
    }

    public DingoFilter getFilter() {
        return this.filter;
    }

    public boolean isSkippedWhenExisted() {
        return this.skippedWhenExisted;
    }

    public ContextForClient(List<Key> startKeyList, List<Key> endKeyList, List<Record> recordList, List<Operation> operationList, UDFContext udfContext, DingoFilter filter, boolean skippedWhenExisted) {
        this.startKeyList = startKeyList;
        this.endKeyList = endKeyList;
        this.recordList = recordList;
        this.operationList = operationList;
        this.udfContext = udfContext;
        this.filter = filter;
        this.skippedWhenExisted = skippedWhenExisted;
    }

    public static class ContextForClientBuilder {
        private List<Key> startKeyList;
        private List<Key> endKeyList;
        private List<Record> recordList;
        private List<Operation> operationList;
        private UDFContext udfContext;
        private DingoFilter filter;
        private boolean skippedWhenExisted;

        ContextForClientBuilder() {
        }

        public ContextForClientBuilder startKeyList(List<Key> startKeyList) {
            this.startKeyList = startKeyList;
            return this;
        }

        public ContextForClientBuilder endKeyList(List<Key> endKeyList) {
            this.endKeyList = endKeyList;
            return this;
        }

        public ContextForClientBuilder recordList(List<Record> recordList) {
            this.recordList = recordList;
            return this;
        }

        public ContextForClientBuilder operationList(List<Operation> operationList) {
            this.operationList = operationList;
            return this;
        }

        public ContextForClientBuilder udfContext(UDFContext udfContext) {
            this.udfContext = udfContext;
            return this;
        }

        public ContextForClientBuilder filter(DingoFilter filter) {
            this.filter = filter;
            return this;
        }

        public ContextForClientBuilder skippedWhenExisted(boolean skippedWhenExisted) {
            this.skippedWhenExisted = skippedWhenExisted;
            return this;
        }

        public ContextForClient build() {
            return new ContextForClient(this.startKeyList, this.endKeyList, this.recordList, this.operationList, this.udfContext, this.filter, this.skippedWhenExisted);
        }

        public String toString() {
            return "ContextForClient.ContextForClientBuilder(startKeyList=" + this.startKeyList + ", endKeyList=" + this.endKeyList + ", recordList=" + this.recordList + ", operationList=" + this.operationList + ", udfContext=" + this.udfContext + ", filter=" + this.filter + ", skippedWhenExisted=" + this.skippedWhenExisted + ")";
        }
    }
}

