/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.operation;

import io.dingodb.common.operation.context.OperationContext;
import io.dingodb.common.store.KeyValue;
import io.dingodb.sdk.operation.UDFContext;
import java.util.Arrays;
import java.util.List;

public final class ContextForStore {
    private final List<byte[]> startKeyListInBytes;
    private final List<byte[]> endKeyListInBytes;
    private final List<KeyValue> recordList;
    private final List<byte[]> operationListInBytes;
    private final UDFContext udfContext;
    private final boolean skippedWhenExisted;
    private final OperationContext context;

    public KeyValue getRecordByKey(byte[] key) {
        if (this.recordList == null) {
            return null;
        }
        KeyValue result = null;
        for (KeyValue record : this.recordList) {
            if (!Arrays.equals(record.getKey(), key)) continue;
            result = record;
            break;
        }
        return result;
    }

    public static ContextForStoreBuilder builder() {
        return new ContextForStoreBuilder();
    }

    public List<byte[]> getStartKeyListInBytes() {
        return this.startKeyListInBytes;
    }

    public List<byte[]> getEndKeyListInBytes() {
        return this.endKeyListInBytes;
    }

    public List<KeyValue> getRecordList() {
        return this.recordList;
    }

    public List<byte[]> getOperationListInBytes() {
        return this.operationListInBytes;
    }

    public UDFContext getUdfContext() {
        return this.udfContext;
    }

    public boolean isSkippedWhenExisted() {
        return this.skippedWhenExisted;
    }

    public OperationContext getContext() {
        return this.context;
    }

    public ContextForStore(List<byte[]> startKeyListInBytes, List<byte[]> endKeyListInBytes, List<KeyValue> recordList, List<byte[]> operationListInBytes, UDFContext udfContext, boolean skippedWhenExisted, OperationContext context) {
        this.startKeyListInBytes = startKeyListInBytes;
        this.endKeyListInBytes = endKeyListInBytes;
        this.recordList = recordList;
        this.operationListInBytes = operationListInBytes;
        this.udfContext = udfContext;
        this.skippedWhenExisted = skippedWhenExisted;
        this.context = context;
    }

    public static class ContextForStoreBuilder {
        private List<byte[]> startKeyListInBytes;
        private List<byte[]> endKeyListInBytes;
        private List<KeyValue> recordList;
        private List<byte[]> operationListInBytes;
        private UDFContext udfContext;
        private boolean skippedWhenExisted;
        private OperationContext context;

        ContextForStoreBuilder() {
        }

        public ContextForStoreBuilder startKeyListInBytes(List<byte[]> startKeyListInBytes) {
            this.startKeyListInBytes = startKeyListInBytes;
            return this;
        }

        public ContextForStoreBuilder endKeyListInBytes(List<byte[]> endKeyListInBytes) {
            this.endKeyListInBytes = endKeyListInBytes;
            return this;
        }

        public ContextForStoreBuilder recordList(List<KeyValue> recordList) {
            this.recordList = recordList;
            return this;
        }

        public ContextForStoreBuilder operationListInBytes(List<byte[]> operationListInBytes) {
            this.operationListInBytes = operationListInBytes;
            return this;
        }

        public ContextForStoreBuilder udfContext(UDFContext udfContext) {
            this.udfContext = udfContext;
            return this;
        }

        public ContextForStoreBuilder skippedWhenExisted(boolean skippedWhenExisted) {
            this.skippedWhenExisted = skippedWhenExisted;
            return this;
        }

        public ContextForStoreBuilder context(OperationContext context) {
            this.context = context;
            return this;
        }

        public ContextForStore build() {
            return new ContextForStore(this.startKeyListInBytes, this.endKeyListInBytes, this.recordList, this.operationListInBytes, this.udfContext, this.skippedWhenExisted, this.context);
        }

        public String toString() {
            return "ContextForStore.ContextForStoreBuilder(startKeyListInBytes=" + this.startKeyListInBytes + ", endKeyListInBytes=" + this.endKeyListInBytes + ", recordList=" + this.recordList + ", operationListInBytes=" + this.operationListInBytes + ", udfContext=" + this.udfContext + ", skippedWhenExisted=" + this.skippedWhenExisted + ", context=" + this.context + ")";
        }
    }
}

