/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.operation;

import io.dingodb.common.codec.KeyValueCodec;
import io.dingodb.common.codec.ProtostuffCodec;
import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.context.BasicContext;
import io.dingodb.common.store.KeyValue;
import io.dingodb.common.table.ColumnDefinition;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.sdk.common.Record;
import io.dingodb.sdk.operation.ContextForClient;
import io.dingodb.sdk.operation.ContextForStore;
import io.dingodb.sdk.operation.ResultForClient;
import io.dingodb.sdk.operation.ResultForStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Converter {
    private static final Logger log = LoggerFactory.getLogger(Converter.class);

    public static ResultForClient getResultCode(ResultForStore result4Store, KeyValueCodec codec, List<ColumnDefinition> columnDefList) {
        boolean status2 = result4Store.getStatus();
        String errorMessage = result4Store.getErrorMessage();
        List records = null;
        if (result4Store.getRecords() != null && !result4Store.getRecords().isEmpty()) {
            records = result4Store.getRecords().stream().filter(kv -> kv.getValue() != null).map(kv -> {
                try {
                    ArrayList<Column> columnArray = new ArrayList<Column>();
                    Object[] columnValues = codec.decode((KeyValue)kv);
                    for (int i = 0; i < columnValues.length; ++i) {
                        Column column = new Column(((ColumnDefinition)columnDefList.get(i)).getName(), columnValues[i]);
                        columnArray.add(column);
                    }
                    return new Record(columnDefList, columnArray.toArray(new Column[columnArray.size()]));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        return new ResultForClient(status2, errorMessage, records);
    }

    public static ContextForStore getStoreContext(ContextForClient inputContext, KeyValueCodec codec, TableDefinition definition) {
        List<byte[]> startKeyListInBytes = null;
        startKeyListInBytes = inputContext.getStartKeyList().stream().map(x -> {
            try {
                Object[] keys = x.getUserKey().toArray();
                if (keys.length != definition.getPrimaryKeyCount()) {
                    log.error("Inconsistent number of primary keys:{}", keys);
                }
                return codec.encodeKey(keys);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        List<byte[]> endKeyListInBytes = null;
        if (inputContext.getEndKeyList() != null) {
            endKeyListInBytes = inputContext.getEndKeyList().stream().map(x -> {
                try {
                    Object[] keys = x.getUserKey().toArray();
                    if (keys.length != definition.getPrimaryKeyCount()) {
                        log.error("Inconsistent number of primary keys:{}", keys);
                    }
                    return codec.encodeKey(keys);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        List<KeyValue> keyValueList = null;
        if (inputContext.getRecordList() != null) {
            keyValueList = inputContext.getRecordList().stream().map(x -> {
                try {
                    Object[] columnValues = x.getColumnValuesInOrder().toArray();
                    KeyValue keyValue = codec.encode(columnValues);
                    return keyValue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        List<byte[]> operationListInBytes = null;
        if (inputContext.getOperationList() != null) {
            operationListInBytes = inputContext.getOperationList().stream().peek(op -> op.operationContext.definition(definition)).map(ProtostuffCodec::write).collect(Collectors.toList());
        }
        BasicContext context = null;
        if (inputContext.getFilter() != null) {
            context = new BasicContext(new Column[0]);
            context.definition(definition);
            context.filter(inputContext.getFilter());
        }
        return ContextForStore.builder().startKeyListInBytes(startKeyListInBytes).endKeyListInBytes(endKeyListInBytes).recordList(keyValueList).operationListInBytes(operationListInBytes).udfContext(inputContext.getUdfContext()).skippedWhenExisted(inputContext.isSkippedWhenExisted()).context(context).build();
    }
}

