/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.operation;

import io.dingodb.common.CommonId;
import io.dingodb.common.codec.KeyValueCodec;
import io.dingodb.common.concurrent.Executors;
import io.dingodb.common.operation.DingoExecResult;
import io.dingodb.common.partition.RangeStrategy;
import io.dingodb.common.store.KeyValue;
import io.dingodb.common.table.DingoKeyValueCodec;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.common.util.ByteArrayUtils;
import io.dingodb.meta.Part;
import io.dingodb.sdk.client.DingoConnection;
import io.dingodb.sdk.client.MetaClient;
import io.dingodb.sdk.client.RouteTable;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.operation.CallableTask;
import io.dingodb.sdk.operation.ContextForClient;
import io.dingodb.sdk.operation.ContextForStore;
import io.dingodb.sdk.operation.Converter;
import io.dingodb.sdk.operation.IStoreOperation;
import io.dingodb.sdk.operation.ResultForClient;
import io.dingodb.sdk.operation.ResultForStore;
import io.dingodb.sdk.operation.StoreOperationFactory;
import io.dingodb.sdk.operation.StoreOperationType;
import io.dingodb.server.api.ExecutorApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreOperationUtils {
    private static final Logger log = LoggerFactory.getLogger(StoreOperationUtils.class);
    private static Map<String, RouteTable> dingoRouteTables = new TreeMap<String, RouteTable>(String.CASE_INSENSITIVE_ORDER);
    private static Map<String, TableDefinition> tableDefinitionInCache = new TreeMap<String, TableDefinition>(String.CASE_INSENSITIVE_ORDER);
    private DingoConnection connection;
    private int retryTimes;

    public StoreOperationUtils(DingoConnection connection, int retryTimes) {
        this.connection = connection;
        this.retryTimes = retryTimes;
    }

    public void shutdown() {
        this.clearTableDefinitionInCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DingoExecResult> doOperation(String tableName, ContextForClient storeParameters) {
        RouteTable routeTable = this.getAndRefreshRouteTable(tableName, false);
        if (routeTable == null) {
            log.error("table {} not found when do operation", (Object)tableName);
            return null;
        }
        boolean isSuccess = false;
        int retryTimes = this.retryTimes;
        ArrayList<DingoExecResult> results = new ArrayList<DingoExecResult>();
        do {
            try {
                KeyValueCodec codec = routeTable.getCodec();
                TableDefinition tableDefinition = this.getTableDefinition(tableName);
                ContextForStore storeContext = Converter.getStoreContext(storeParameters, codec, tableDefinition);
                Map<String, ContextForStore> keys2Executor = this.groupKeysByExecutor(routeTable, null, tableName, storeContext);
                ArrayList<CompletableFuture<List>> futureArrayList = new ArrayList<CompletableFuture<List>>();
                for (Map.Entry<String, ContextForStore> entry : keys2Executor.entrySet()) {
                    String leaderAddress = entry.getKey();
                    ContextForStore forStore = entry.getValue();
                    ExecutorApi executorApi = this.getExecutor(routeTable, leaderAddress);
                    RouteTable finalRouteTable = routeTable;
                    CompletableFuture<List> future = Executors.submit("compute-operation", () -> executorApi.operator(finalRouteTable.getTableId(), forStore.getStartKeyListInBytes(), forStore.getEndKeyListInBytes(), forStore.getOperationListInBytes()));
                    futureArrayList.add(future);
                }
                for (Future future : futureArrayList) {
                    List dingoExecResults = (List)future.get();
                    for (DingoExecResult dingoExecResult : dingoExecResults) {
                        isSuccess = dingoExecResult.isSuccess();
                        results.add(dingoExecResult);
                    }
                }
            }
            catch (Exception e) {
                log.error("operation fail.", e);
            }
            finally {
                if (!isSuccess && retryTimes > 0) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    routeTable = this.getAndRefreshRouteTable(tableName, true);
                }
            }
        } while (!isSuccess && --retryTimes > 0);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultForClient doOperation(StoreOperationType type2, String tableName, ContextForClient storeParameters) {
        RouteTable routeTable = this.getAndRefreshRouteTable(tableName, false);
        if (routeTable == null) {
            log.error("table {} not found when do operation:{}", (Object)tableName, (Object)type2);
            return new ResultForClient(false, null);
        }
        boolean isSuccess = false;
        String errorMsg = "";
        int retryTimes = this.retryTimes;
        ResultForClient result4Client = null;
        do {
            try {
                KeyValueCodec codec = routeTable.getCodec();
                TableDefinition tableDefinition = this.getTableDefinition(tableName);
                IStoreOperation storeOperation = StoreOperationFactory.getStoreOperation(type2);
                ContextForStore context4Store = Converter.getStoreContext(storeParameters, codec, tableDefinition);
                Map<String, ContextForStore> keys2Executor = this.groupKeysByExecutor(routeTable, type2, tableName, context4Store);
                ArrayList<CompletableFuture<ResultForStore>> futureArrayList = new ArrayList<CompletableFuture<ResultForStore>>();
                for (Map.Entry<String, ContextForStore> entry : keys2Executor.entrySet()) {
                    String leaderAddress = entry.getKey();
                    ExecutorApi executorApi = this.getExecutor(routeTable, leaderAddress);
                    futureArrayList.add(Executors.submit("do-operation", new CallableTask(executorApi, storeOperation, routeTable.getTableId(), entry.getValue())));
                }
                ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>();
                for (Future subFutureResult : futureArrayList) {
                    ResultForStore subResult4Store = (ResultForStore)subFutureResult.get();
                    isSuccess = subResult4Store.getStatus();
                    if (!isSuccess) {
                        errorMsg = subResult4Store.getErrorMessage();
                        throw new DingoClientException(errorMsg);
                    }
                    if (subResult4Store.getRecords() == null || subResult4Store.getRecords().size() <= 0) continue;
                    keyValueList.addAll(subResult4Store.getRecords());
                }
                ResultForStore resultForStore = new ResultForStore(isSuccess, errorMsg, keyValueList);
                result4Client = Converter.getResultCode(resultForStore, codec, this.getTableDefinition(tableName).getColumns());
            }
            catch (Exception ex) {
                errorMsg = "Execute operation:" + (Object)((Object)type2) + " failed, retry times:" + retryTimes;
                log.error(errorMsg, ex);
                result4Client = new ResultForClient(false, errorMsg);
            }
            finally {
                if (!isSuccess && retryTimes > 0) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    routeTable = this.getAndRefreshRouteTable(tableName, true);
                }
            }
        } while (!isSuccess && --retryTimes > 0);
        if (retryTimes == 0 || !isSuccess) {
            log.error("Execute operation:{} on table:{} failed, retry times:{}", new Object[]{type2, tableName, retryTimes});
        }
        return result4Client;
    }

    private Map<String, ContextForStore> groupKeysByExecutor(RouteTable routeTable, StoreOperationType type2, String tableName, ContextForStore wholeContext) {
        TreeMap<String, ArrayList<byte[]>> keyListByExecutor = new TreeMap<String, ArrayList<byte[]>>();
        for (int index = 0; index < wholeContext.getStartKeyListInBytes().size(); ++index) {
            byte[] keyInBytes = wholeContext.getStartKeyListInBytes().get(index);
            String leaderAddress = this.getLeaderAddressByStartKey(routeTable, keyInBytes);
            if (leaderAddress == null) {
                log.error("Cannot find partition, table {} key:{} not found when do operation:{}", new Object[]{tableName, Arrays.toString(keyInBytes), type2});
                throw new DingoClientException("table " + tableName + " key:" + Arrays.toString(keyInBytes) + " not found when do operation:" + (Object)((Object)type2));
            }
            ArrayList<byte[]> keyList = (ArrayList<byte[]>)keyListByExecutor.get(leaderAddress);
            if (keyList == null) {
                keyList = new ArrayList<byte[]>();
                keyListByExecutor.put(leaderAddress, keyList);
            }
            keyList.add(keyInBytes);
        }
        TreeMap<String, ContextForStore> contextGroupyByExecutor = new TreeMap<String, ContextForStore>();
        for (Map.Entry entry : keyListByExecutor.entrySet()) {
            String leaderAddress = (String)entry.getKey();
            List keys = (List)entry.getValue();
            ArrayList<KeyValue> records = new ArrayList<KeyValue>();
            for (byte[] key : keys) {
                records.add(wholeContext.getRecordByKey(key));
            }
            ContextForStore subStoreContext = ContextForStore.builder().startKeyListInBytes(keys).endKeyListInBytes(wholeContext.getEndKeyListInBytes()).recordList(records).operationListInBytes(wholeContext.getOperationListInBytes()).udfContext(wholeContext.getUdfContext()).skippedWhenExisted(wholeContext.isSkippedWhenExisted()).context(wholeContext.getContext()).build();
            contextGroupyByExecutor.put(leaderAddress, subStoreContext);
        }
        return contextGroupyByExecutor;
    }

    public synchronized RouteTable getAndRefreshRouteTable(String tableName, boolean isRefresh) {
        RouteTable routeTable;
        if (isRefresh) {
            dingoRouteTables.remove(tableName);
        }
        if ((routeTable = dingoRouteTables.get(tableName)) == null) {
            MetaClient metaClient = this.connection.getMetaClient();
            TableDefinition tableDefinition = metaClient.getTableDefinition(tableName);
            if (tableDefinition == null) {
                log.error("Cannot find table:{} definition from meta", (Object)tableName);
                return null;
            }
            tableDefinitionInCache.put(tableName, tableDefinition);
            NavigableMap<ByteArrayUtils.ComparableByteArray, Part> partitions = metaClient.getParts(tableDefinition.getName());
            DingoKeyValueCodec keyValueCodec = new DingoKeyValueCodec(tableDefinition.getDingoType(), tableDefinition.getKeyMapping());
            RangeStrategy rangeStrategy = new RangeStrategy(tableDefinition, partitions.navigableKeySet());
            CommonId tableId = metaClient.getTableId(tableDefinition.getName());
            routeTable = new RouteTable(tableName, tableId, keyValueCodec, partitions, rangeStrategy);
            dingoRouteTables.put(tableName, routeTable);
            log.info("Refresh route table:{}, tableDef:{}", (Object)tableName, (Object)tableDefinition);
        }
        return routeTable;
    }

    public synchronized TableDefinition getTableDefinition(String tableName) {
        MetaClient metaClient;
        TableDefinition tableDef = tableDefinitionInCache.get(tableName);
        if (tableDef == null && (tableDef = (metaClient = this.connection.getMetaClient()).getTableDefinition(tableName)) != null) {
            tableDefinitionInCache.put(tableName, tableDef);
        }
        if (tableDef == null) {
            log.error("Cannot find table:{} definition from meta", (Object)tableName);
            return null;
        }
        return tableDef;
    }

    public synchronized void updateCacheOfTableDefinition(String tableName, TableDefinition tableDef) {
        if (tableName != null && !tableName.isEmpty() && tableDef != null) {
            tableDefinitionInCache.put(tableName, tableDef);
            log.info("update cache of table:{} definition:{}", (Object)tableName, (Object)tableDef);
        }
    }

    public synchronized void removeCacheOfTableDefinition(String tableName) {
        if (tableName != null) {
            TableDefinition tableDefinition = tableDefinitionInCache.remove(tableName);
            dingoRouteTables.remove(tableName);
            if (tableDefinition != null) {
                log.info("remove cache of table:{} definition:{}", (Object)tableName, (Object)tableDefinition);
            }
        }
    }

    public static Map<String, TableDefinition> getTableDefinitionInCache() {
        return tableDefinitionInCache;
    }

    private synchronized void clearTableDefinitionInCache() {
        tableDefinitionInCache.clear();
    }

    private synchronized ExecutorApi getExecutor(RouteTable routeTable, String leaderAddress) {
        ExecutorApi executorApi = routeTable.getLeaderAddress(this.connection.getApiRegistry(), leaderAddress);
        return executorApi;
    }

    private synchronized String getLeaderAddressByStartKey(RouteTable routeTable, byte[] keyInBytes) {
        return routeTable.getStartPartitionKey(this.connection.getApiRegistry(), keyInBytes);
    }
}

