/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.operation.impl;

import io.dingodb.common.CommonId;
import io.dingodb.sdk.operation.ContextForStore;
import io.dingodb.sdk.operation.IStoreOperation;
import io.dingodb.sdk.operation.ResultForStore;
import io.dingodb.server.api.ExecutorApi;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteOperation
implements IStoreOperation {
    private static final Logger log = LoggerFactory.getLogger(DeleteOperation.class);
    private static final DeleteOperation instance = new DeleteOperation();

    private DeleteOperation() {
    }

    public static DeleteOperation getInstance() {
        return instance;
    }

    @Override
    public ResultForStore doOperation(ExecutorApi executorApi, CommonId tableId, ContextForStore parameters) {
        try {
            if (parameters == null || parameters.getStartKeyListInBytes().size() < 1) {
                String errorMessage = "Delete operation requires at least one key";
                return new ResultForStore(false, errorMessage);
            }
            List<byte[]> keyList = parameters.getStartKeyListInBytes();
            boolean result = executorApi.delete(tableId, keyList);
            return new ResultForStore(result, "OK");
        }
        catch (Exception e) {
            log.error("delete KeyValue error, tableId:{}, exception:{}", tableId, e.toString(), e);
            throw e;
        }
    }
}

