/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.operation.impl;

import io.dingodb.common.CommonId;
import io.dingodb.common.store.KeyValue;
import io.dingodb.sdk.operation.ContextForStore;
import io.dingodb.sdk.operation.IStoreOperation;
import io.dingodb.sdk.operation.ResultForStore;
import io.dingodb.server.api.ExecutorApi;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOperation
implements IStoreOperation {
    private static final Logger log = LoggerFactory.getLogger(GetOperation.class);
    private static final GetOperation instance = new GetOperation();

    private GetOperation() {
    }

    public static GetOperation getInstance() {
        return instance;
    }

    @Override
    public ResultForStore doOperation(ExecutorApi executorApi, CommonId tableId, ContextForStore parameters) {
        try {
            if (parameters == null || parameters.getStartKeyListInBytes().size() < 1) {
                log.error("Parameters is null || table:{} has non key columns", (Object)tableId);
                return new ResultForStore(false, "Invalid parameters for get operation");
            }
            List<byte[]> keyList = parameters.getStartKeyListInBytes();
            List<KeyValue> recordList = executorApi.getKeyValueByPrimaryKeys(tableId, keyList);
            return new ResultForStore(true, "OK", recordList);
        }
        catch (Exception e) {
            log.error("doGet KeyValue error, tableId:{}, exception:{}", tableId, e.toString(), e);
            throw e;
        }
    }
}

