/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.operation.impl;

import io.dingodb.common.CommonId;
import io.dingodb.common.store.KeyValue;
import io.dingodb.sdk.operation.ContextForStore;
import io.dingodb.sdk.operation.IStoreOperation;
import io.dingodb.sdk.operation.ResultForStore;
import io.dingodb.server.api.ExecutorApi;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutOperation
implements IStoreOperation {
    private static final Logger log = LoggerFactory.getLogger(PutOperation.class);
    private static final PutOperation instance = new PutOperation();

    private PutOperation() {
    }

    public static PutOperation getInstance() {
        return instance;
    }

    @Override
    public ResultForStore doOperation(ExecutorApi executorApi, CommonId tableId, ContextForStore parameters) {
        try {
            if (parameters == null || parameters.getStartKeyListInBytes().size() != parameters.getRecordList().size()) {
                log.error("Parameters is null || table:{} has non key columns", (Object)tableId);
                String errorMsg = "Invalid parameters for put operation";
                return new ResultForStore(false, errorMsg);
            }
            List<KeyValue> keyValueList = parameters.getRecordList();
            if (parameters.isSkippedWhenExisted()) {
                keyValueList = parameters.getRecordList().stream().filter(record -> !executorApi.exist(tableId, record.getKey())).collect(Collectors.toList());
            }
            boolean isSuccess = true;
            if (!keyValueList.isEmpty()) {
                isSuccess = executorApi.upsertKeyValue(tableId, keyValueList);
            }
            return new ResultForStore(isSuccess, "OK");
        }
        catch (Exception e) {
            log.error("put table:{} by KeyValue catch exception:{}", tableId, e.toString(), e);
            throw e;
        }
    }
}

