/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.operation.impl;

import io.dingodb.common.CommonId;
import io.dingodb.common.operation.context.OperationContext;
import io.dingodb.common.store.KeyValue;
import io.dingodb.sdk.operation.ContextForStore;
import io.dingodb.sdk.operation.IStoreOperation;
import io.dingodb.sdk.operation.ResultForStore;
import io.dingodb.server.api.ExecutorApi;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryOperation
implements IStoreOperation {
    private static final Logger log = LoggerFactory.getLogger(QueryOperation.class);
    public static final QueryOperation instance = new QueryOperation();

    public static QueryOperation getInstance() {
        return instance;
    }

    @Override
    public ResultForStore doOperation(ExecutorApi executorApi, CommonId tableId, ContextForStore parameters) {
        try {
            if (parameters == null || parameters.getStartKeyListInBytes().size() < 1 || parameters.getEndKeyListInBytes().size() < 1) {
                log.error("Parameters is null || table:{} has non key columns", (Object)tableId);
                return new ResultForStore(false, "Invalid parameters for query operation");
            }
            List<byte[]> startKeys = parameters.getStartKeyListInBytes();
            List<byte[]> endKeys = parameters.getEndKeyListInBytes();
            List<KeyValue> keyValueList = executorApi.getKeyValueByRange(tableId, startKeys.get(0), endKeys.get(0));
            OperationContext context = parameters.getContext();
            if (context == null) {
                return new ResultForStore(true, "OK", keyValueList);
            }
            List<KeyValue> recordList = keyValueList.stream().filter(kv -> context.filter.filter(context, (KeyValue)kv)).collect(Collectors.toList());
            return new ResultForStore(true, "OK", recordList);
        }
        catch (Exception e) {
            log.error("deQuery KeyValue error, tableId:{}, exception:{}", (Object)tableId, (Object)e);
            throw e;
        }
    }
}

