/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.operation.impl;

import io.dingodb.common.CommonId;
import io.dingodb.common.store.KeyValue;
import io.dingodb.sdk.operation.ContextForStore;
import io.dingodb.sdk.operation.IStoreOperation;
import io.dingodb.sdk.operation.ResultForStore;
import io.dingodb.sdk.operation.UDFContext;
import io.dingodb.server.api.ExecutorApi;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdfUpdateOperation
implements IStoreOperation {
    private static final Logger log = LoggerFactory.getLogger(UdfUpdateOperation.class);
    private static final UdfUpdateOperation instance = new UdfUpdateOperation();

    private UdfUpdateOperation() {
    }

    public static UdfUpdateOperation getInstance() {
        return instance;
    }

    @Override
    public ResultForStore doOperation(ExecutorApi executorApi, CommonId tableId, ContextForStore parameters) {
        try {
            if (parameters == null || parameters.getStartKeyListInBytes().size() != parameters.getRecordList().size()) {
                log.error("Parameters is null || table:{} has non key columns", (Object)tableId);
                String errorMsg = "Invalid parameters for put operation";
                return new ResultForStore(false, errorMsg);
            }
            List<byte[]> keyList = parameters.getStartKeyListInBytes();
            ArrayList<KeyValue> failedKeyList = new ArrayList<KeyValue>();
            UDFContext udfContext = parameters.getUdfContext();
            for (byte[] primaryKey : keyList) {
                if (executorApi.udfUpdate(tableId, primaryKey, udfContext.getUdfName(), udfContext.getFunctionName(), udfContext.getUdfVersion())) continue;
                failedKeyList.add(new KeyValue(primaryKey, null));
            }
            if (failedKeyList.size() == 0) {
                return new ResultForStore(true, "OK");
            }
            return new ResultForStore(false, "udfUpdate Failed", failedKeyList);
        }
        catch (Exception e) {
            log.error("udfUpdate table:{} by KeyValue catch exception:{}", tableId, e.toString(), e);
            throw e;
        }
    }
}

