/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.utils;

import io.dingodb.sdk.client.IBaseDingoMapper;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.configuration.ClassConfig;
import io.dingodb.sdk.configuration.Configuration;
import io.dingodb.sdk.utils.ClassCacheEntry;
import io.dingodb.sdk.utils.NotAnnotatedClass;
import io.dingodb.sdk.utils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class ClassCache {
    private static final ClassCache instance = new ClassCache();
    private final Map<Class<?>, ClassCacheEntry<?>> cacheMap = new HashMap();
    private final Map<String, ClassConfig> classesConfig = new HashMap<String, ClassConfig>();
    private final Map<String, ClassCacheEntry<?>> storedNameToCacheEntry = new HashMap();
    private final Object lock = new Object();

    public static ClassCache getInstance() {
        return instance;
    }

    private ClassCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ClassCacheEntry<T> loadClass(@NotNull Class<T> clazz, IBaseDingoMapper mapper) {
        if (clazz.isPrimitive() || clazz.equals(Object.class) || clazz.equals(String.class) || clazz.equals(Character.class) || Number.class.isAssignableFrom(clazz)) {
            return null;
        }
        ClassCacheEntry<Object> entry = this.cacheMap.get(clazz);
        if (entry == null || entry.isNotConstructed()) {
            Object object = this.lock;
            synchronized (object) {
                entry = this.cacheMap.get(clazz);
                if (entry == null) {
                    try {
                        entry = new ClassCacheEntry<T>(clazz, mapper, this.getClassConfig(clazz));
                    }
                    catch (NotAnnotatedClass nae) {
                        return null;
                    }
                    this.cacheMap.put(clazz, entry);
                    try {
                        entry.construct();
                    }
                    catch (IllegalArgumentException iae) {
                        this.cacheMap.remove(clazz);
                        return null;
                    }
                    catch (Exception e) {
                        this.cacheMap.remove(clazz);
                        throw e;
                    }
                }
            }
        }
        return entry;
    }

    void setStoredName(@NotNull ClassCacheEntry<?> entry, @NotNull String name) {
        ClassCacheEntry<?> existingEntry = this.storedNameToCacheEntry.get(name);
        if (existingEntry != null && !existingEntry.equals(entry)) {
            String errorMessage = String.format("Stored name of \"%s\" is used for both %s and %s", name, existingEntry.getUnderlyingClass().getName(), entry.getUnderlyingClass().getName());
            throw new DingoClientException(errorMessage);
        }
        this.storedNameToCacheEntry.put(name, entry);
    }

    public ClassCacheEntry<?> getCacheEntryFromStoredName(@NotNull String name) {
        return this.storedNameToCacheEntry.get(name);
    }

    public boolean hasClass(Class<?> clazz) {
        return this.cacheMap.containsKey(clazz);
    }

    public void clear() {
        this.cacheMap.clear();
        this.classesConfig.clear();
        TypeUtils.clear();
        this.storedNameToCacheEntry.clear();
    }

    public void addConfiguration(@NotNull Configuration configuration) {
        for (ClassConfig thisConfig : configuration.getClasses()) {
            this.classesConfig.put(thisConfig.getClassName(), thisConfig);
        }
    }

    public ClassConfig getClassConfig(String className) {
        return this.classesConfig.get(className);
    }

    public ClassConfig getClassConfig(Class<?> clazz) {
        return this.classesConfig.get(clazz.getName());
    }

    public boolean hasClassConfig(String className) {
        return this.classesConfig.containsKey(className);
    }

    public boolean hasClassConfig(Class<?> clazz) {
        return this.classesConfig.containsKey(clazz.getName());
    }

    static enum PolicyType {
        READ,
        WRITE,
        BATCH,
        SCAN,
        QUERY;

    }
}

