/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.utils;

import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.MapOrder;
import io.dingodb.common.operation.Value;
import io.dingodb.common.table.ColumnDefinition;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.sdk.annotation.DingoColumn;
import io.dingodb.sdk.annotation.DingoConstructor;
import io.dingodb.sdk.annotation.DingoExclude;
import io.dingodb.sdk.annotation.DingoGetter;
import io.dingodb.sdk.annotation.DingoKey;
import io.dingodb.sdk.annotation.DingoOrdinal;
import io.dingodb.sdk.annotation.DingoRecord;
import io.dingodb.sdk.annotation.DingoSetter;
import io.dingodb.sdk.annotation.ParamFrom;
import io.dingodb.sdk.client.IBaseDingoMapper;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.Key;
import io.dingodb.sdk.common.PropertyDefinition;
import io.dingodb.sdk.common.Record;
import io.dingodb.sdk.common.SqlTypeInfo;
import io.dingodb.sdk.common.ValueType;
import io.dingodb.sdk.configuration.ClassConfig;
import io.dingodb.sdk.configuration.ColumnConfig;
import io.dingodb.sdk.configuration.KeyConfig;
import io.dingodb.sdk.mappers.TypeMapper;
import io.dingodb.sdk.utils.ClassCache;
import io.dingodb.sdk.utils.LoadedObjectResolver;
import io.dingodb.sdk.utils.NotAnnotatedClass;
import io.dingodb.sdk.utils.ParserUtils;
import io.dingodb.sdk.utils.PrimitiveDefaults;
import io.dingodb.sdk.utils.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassCacheEntry<T> {
    private static final Logger log = LoggerFactory.getLogger(ClassCacheEntry.class);
    public static final String VERSION_PREFIX = "@V";
    public static final String TYPE_PREFIX = "@T:";
    public static final String TYPE_NAME = ".type";
    private String database;
    private String tableName;
    private int version = 1;
    private final Class<T> clazz;
    private List<ValueType> keys = new ArrayList<ValueType>();
    private boolean mapAll = true;
    private List<String> keysName = new ArrayList<String>();
    private final TreeMap<String, ValueType> values = new TreeMap();
    private ClassCacheEntry<?> superClazz;
    private int columnCnt;
    private final IBaseDingoMapper mapper;
    private Map<Integer, String> ordinals = null;
    private Set<String> fieldsWithOrdinals = null;
    private final ClassConfig classConfig;
    private String[] constructorParamBins;
    private Object[] constructorParamDefaults;
    private Constructor<T> constructor;
    private final ClassConfig config;
    private String factoryMethod;
    private String factoryClass;
    private Method factoryConstructorMethod;
    private FactoryMethodType factoryConstructorType;
    private String shortenedClassName;
    private boolean isChildClass = false;
    private volatile boolean constructed;

    ClassCacheEntry(@NotNull Class<T> clazz, IBaseDingoMapper mapper, ClassConfig config) {
        this.clazz = clazz;
        this.mapper = mapper;
        this.classConfig = config;
        DingoRecord recordDescription = clazz.getAnnotation(DingoRecord.class);
        if (recordDescription == null && config == null) {
            throw new NotAnnotatedClass("Class " + clazz.getName() + " is not augmented by the @DingoRecord annotation");
        }
        if (recordDescription != null) {
            this.database = ParserUtils.getInstance().get(recordDescription.database());
            this.tableName = ParserUtils.getInstance().get(recordDescription.table().toUpperCase());
            this.factoryClass = recordDescription.factoryClass();
            this.factoryMethod = recordDescription.factoryMethod();
        }
        this.config = config;
    }

    public ClassCacheEntry<T> construct() {
        if (this.config != null) {
            this.config.validate();
            this.overrideSettings(this.config);
        }
        this.loadFieldsFromClass();
        this.loadPropertiesFromClass();
        this.superClazz = ClassCache.getInstance().loadClass(this.clazz.getSuperclass(), this.mapper);
        this.columnCnt = this.values.size() + (this.superClazz != null ? this.superClazz.columnCnt : 0);
        if (this.columnCnt == 0) {
            throw new DingoClientException("Class " + this.clazz.getSimpleName() + " has no values defined to be stored in the database");
        }
        this.formOrdinalsFromValues();
        Method factoryConstructorMethod = this.findConstructorFactoryMethod();
        if (factoryConstructorMethod == null) {
            this.findConstructor();
        } else {
            this.setConstructorFactoryMethod(factoryConstructorMethod);
        }
        if (StringUtils.isBlank(this.shortenedClassName)) {
            this.shortenedClassName = this.clazz.getSimpleName();
        }
        ClassCache.getInstance().setStoredName(this, this.shortenedClassName);
        this.checkRecordSettingsAgainstSuperClasses();
        this.constructed = true;
        return this;
    }

    public boolean isNotConstructed() {
        return !this.constructed;
    }

    public Class<?> getUnderlyingClass() {
        return this.clazz;
    }

    public ClassConfig getClassConfig() {
        return this.classConfig;
    }

    public String getShortenedClassName() {
        return this.shortenedClassName;
    }

    private void overrideSettings(ClassConfig config) {
        if (!StringUtils.isBlank(config.getDatabase())) {
            this.database = config.getDatabase();
        }
        if (!StringUtils.isBlank(config.getTable())) {
            this.tableName = config.getTable();
        }
        if (config.getFactoryMethod() != null) {
            this.factoryMethod = config.getFactoryMethod();
        }
        if (config.getFactoryClass() != null) {
            this.factoryClass = config.getFactoryClass();
        }
    }

    public boolean isChildClass() {
        return this.isChildClass;
    }

    private void checkRecordSettingsAgainstSuperClasses() {
        ClassCacheEntry<?> thisEntry;
        if (!StringUtils.isBlank(this.database) && !StringUtils.isBlank(this.tableName)) {
            this.isChildClass = false;
            thisEntry = this.superClazz;
            while (thisEntry != null) {
                boolean isOK;
                boolean bl = isOK = !StringUtils.isBlank(thisEntry.getDatabase()) && !StringUtils.isBlank(thisEntry.getTableName());
                if (isOK) {
                    if (!this.database.equals(thisEntry.getDatabase()) || !this.tableName.equals(thisEntry.getTableName())) break;
                    this.isChildClass = true;
                    break;
                }
                thisEntry = thisEntry.superClazz;
            }
        } else {
            this.isChildClass = true;
            thisEntry = this.superClazz;
            while (thisEntry != null) {
                if (!StringUtils.isBlank(thisEntry.getDatabase()) && !StringUtils.isBlank(thisEntry.getTableName())) {
                    this.database = thisEntry.getDatabase();
                    this.tableName = thisEntry.getTableName();
                    break;
                }
                thisEntry = thisEntry.superClazz;
            }
        }
        thisEntry = this.superClazz;
        while (thisEntry != null) {
            if (thisEntry.keys != null) {
                this.keys = thisEntry.keys;
            }
            thisEntry = thisEntry.superClazz;
        }
    }

    private ColumnConfig getColumnFromName(String name) {
        if (this.classConfig == null || this.classConfig.getColumns() == null) {
            return null;
        }
        for (ColumnConfig thisColumn : this.classConfig.getColumns()) {
            if (!thisColumn.getDerivedName().equals(name)) continue;
            return thisColumn;
        }
        return null;
    }

    private ColumnConfig getColumnFromField(Field field) {
        if (this.classConfig == null || this.classConfig.getColumns() == null) {
            return null;
        }
        for (ColumnConfig thisBin : this.classConfig.getColumns()) {
            if (thisBin.getField() == null || !thisBin.getField().equals(field.getName())) continue;
            return thisBin;
        }
        return null;
    }

    private ColumnConfig getColumnFromGetter(String name) {
        if (this.classConfig == null || this.classConfig.getColumns() == null) {
            return null;
        }
        for (ColumnConfig thisBin : this.classConfig.getColumns()) {
            if (thisBin.getGetter() == null || !thisBin.getGetter().equals(name)) continue;
            return thisBin;
        }
        return null;
    }

    private ColumnConfig getColumnFromSetter(String name) {
        if (this.classConfig == null || this.classConfig.getColumns() == null) {
            return null;
        }
        for (ColumnConfig thisBin : this.classConfig.getColumns()) {
            if (thisBin.getSetter() == null || !thisBin.getSetter().equals(name)) continue;
            return thisBin;
        }
        return null;
    }

    private void formOrdinalsFromValues() {
        for (String thisValueName : this.values.keySet()) {
            Annotation thisAnnotation;
            Annotation[] annotationArray;
            int n;
            int n2;
            Integer ordinal;
            ValueType thisValue = this.values.get(thisValueName);
            ColumnConfig columnConfig = this.getColumnFromName(thisValueName);
            Integer n3 = ordinal = columnConfig == null ? null : columnConfig.getOrdinal();
            if (ordinal == null && (n2 = 0) < (n = (annotationArray = thisValue.getAnnotations()).length) && (thisAnnotation = annotationArray[n2]) instanceof DingoOrdinal) {
                ordinal = ((DingoOrdinal)thisAnnotation).value();
            }
            if (ordinal == null) continue;
            if (this.ordinals == null) {
                this.ordinals = new HashMap<Integer, String>();
                this.fieldsWithOrdinals = new HashSet<String>();
            }
            if (this.ordinals.containsKey(ordinal)) {
                throw new DingoClientException(String.format("Class %s has multiple values with the ordinal of %d", this.clazz.getSimpleName(), ordinal));
            }
            this.ordinals.put(ordinal, thisValueName);
            this.fieldsWithOrdinals.add(thisValueName);
        }
        if (this.ordinals != null) {
            for (int i = 1; i <= this.ordinals.size(); ++i) {
                if (this.ordinals.containsKey(i)) continue;
                throw new DingoClientException(String.format("Class %s has %d values specifying ordinals. These should be 1..%d, but %d is missing", this.clazz.getSimpleName(), this.ordinals.size(), this.ordinals.size(), i));
            }
        }
    }

    private boolean validateFactoryMethod(Method method) {
        if ((method.getModifiers() & 8) == 8 && this.factoryMethod.equals(method.getName())) {
            Parameter[] params = method.getParameters();
            if (params.length == 0) {
                return true;
            }
            if (params.length == 1 && (Class.class.isAssignableFrom(params[0].getType()) || Map.class.isAssignableFrom(params[0].getType()))) {
                return true;
            }
            if (params.length == 2 && Class.class.isAssignableFrom(params[0].getType()) && Map.class.isAssignableFrom(params[1].getType())) {
                return true;
            }
        }
        return false;
    }

    private Method findConstructorFactoryMethod() {
        if (!StringUtils.isBlank(this.factoryClass) || !StringUtils.isBlank(this.factoryMethod)) {
            if (StringUtils.isBlank(this.factoryClass)) {
                String errorMsg = "Missing factoryClass definition when factoryMethod is specified on class " + this.clazz.getSimpleName();
                throw new DingoClientException(errorMsg);
            }
            if (StringUtils.isBlank(this.factoryClass)) {
                String errorMsg = "Missing factoryMethod definition when factoryClass is specified on class " + this.clazz.getSimpleName();
                throw new DingoClientException(errorMsg);
            }
            try {
                Class<?> factoryClazzType = Class.forName(this.factoryClass);
                Method foundMethod = null;
                for (Method method : factoryClazzType.getDeclaredMethods()) {
                    if (!this.validateFactoryMethod(method)) continue;
                    if (foundMethod != null) {
                        throw new DingoClientException(String.format("Factory Class %s defines at least 2 valid factory methods (%s, %s) as a factory for class %s", this.factoryClass, foundMethod, method, this.clazz.getSimpleName()));
                    }
                    foundMethod = method;
                }
                if (foundMethod == null) {
                    throw new DingoClientException(String.format("Class %s specified a factory class of %s and a factory method of %s, but no valid method with that name exists on the class. A valid method must be static, can take no parameters, a single Class parameter, a single Map parameter, or a Class and a Map parameter, and must return an object which is either an ancestor, descendant or equal to %s", this.clazz.getSimpleName(), this.factoryClass, this.factoryMethod, this.clazz.getSimpleName()));
                }
                return foundMethod;
            }
            catch (ClassNotFoundException cnfe) {
                throw new DingoClientException(String.format("Factory class %s for class %s cannot be loaded", this.factoryClass, this.clazz.getSimpleName()));
            }
        }
        return null;
    }

    private void setConstructorFactoryMethod(Method method) {
        this.factoryConstructorMethod = method;
        this.factoryConstructorMethod.setAccessible(true);
        this.factoryConstructorType = method.getParameterCount() == 0 ? FactoryMethodType.NO_PARAMS : (method.getParameterCount() == 2 ? FactoryMethodType.CLASS_MAP : (Class.class.isAssignableFrom(method.getParameters()[0].getType()) ? FactoryMethodType.CLASS : FactoryMethodType.MAP));
    }

    private void findConstructor() {
        Constructor<?>[] constructors = this.clazz.getDeclaredConstructors();
        if (constructors.length == 0) {
            throw new DingoClientException("Class " + this.clazz.getSimpleName() + " has no constructors and hence cannot be mapped to Dingo");
        }
        Constructor<?> desiredConstructor = null;
        Constructor<?> noArgConstructor = null;
        if (constructors.length == 1) {
            desiredConstructor = constructors[0];
        } else {
            for (Constructor<?> thisConstructor : constructors) {
                DingoConstructor dingoConstructor;
                if (thisConstructor.getParameters().length == 0) {
                    noArgConstructor = thisConstructor;
                }
                if ((dingoConstructor = thisConstructor.getAnnotation(DingoConstructor.class)) == null) continue;
                if (desiredConstructor != null) {
                    throw new DingoClientException("Class " + this.clazz.getSimpleName() + " has multiple constructors annotated with @DingoConstructor. Only one constructor can be so annotated.");
                }
                desiredConstructor = thisConstructor;
            }
        }
        if (desiredConstructor == null && noArgConstructor != null) {
            this.constructorParamBins = new String[0];
            desiredConstructor = noArgConstructor;
        }
        if (desiredConstructor == null) {
            throw new DingoClientException("Class " + this.clazz.getSimpleName() + " has neither a no-arg constructor, nor a constructor annotated with @DingoConstructor so cannot be mapped to Dingo.");
        }
        Parameter[] params = desiredConstructor.getParameters();
        this.constructorParamBins = new String[params.length];
        this.constructorParamDefaults = new Object[params.length];
        HashMap<String, ValueType> allValues = new HashMap<String, ValueType>();
        ClassCacheEntry<?> current = this;
        while (current != null) {
            allValues.putAll(current.values);
            current = current.superClazz;
        }
        int count = 0;
        for (Parameter thisParam : params) {
            ++count;
            boolean isFromAnnotation = false;
            String columnName = thisParam.getName();
            ParamFrom parameterDetails = thisParam.getAnnotation(ParamFrom.class);
            if (parameterDetails != null) {
                columnName = parameterDetails.value();
                isFromAnnotation = true;
            }
            if (!allValues.containsKey(columnName)) {
                String valueList = String.join((CharSequence)",", this.values.keySet());
                boolean isDefaultAnnotation = !isFromAnnotation && columnName.startsWith("arg");
                String message = String.format("Class %s has a preferred constructor of %s. However, parameter %d is mapped to column \"%s\" %s which is not one of the values on the class, which are: %s%s", this.clazz.getSimpleName(), desiredConstructor, count, columnName, isFromAnnotation ? "via the @ParamFrom annotation" : "via the argument name", valueList, isDefaultAnnotation ? ". forget to specify '-parameters' to javac when building?" : "");
                throw new DingoClientException(message);
            }
            Class<?> type2 = thisParam.getType();
            if (!type2.isAssignableFrom(((ValueType)allValues.get(columnName)).getType())) {
                throw new DingoClientException("Class " + this.clazz.getSimpleName() + " has a preferred constructor of " + desiredConstructor + ". However, parameter " + count + " is of type " + type2 + " but assigned from column \"" + columnName + "\" of type " + this.values.get(columnName).getType() + ". These types are incompatible.");
            }
            this.constructorParamBins[count - 1] = columnName;
            this.constructorParamDefaults[count - 1] = PrimitiveDefaults.getDefaultValue(thisParam.getType());
        }
        this.constructor = desiredConstructor;
        this.constructor.setAccessible(true);
    }

    private PropertyDefinition getOrCreateProperty(String name, Map<String, PropertyDefinition> properties) {
        PropertyDefinition thisProperty = properties.get(name);
        if (thisProperty == null) {
            thisProperty = new PropertyDefinition(name, this.mapper);
            properties.put(name, thisProperty);
        }
        return thisProperty;
    }

    private void loadPropertiesFromClass() {
        HashMap<String, PropertyDefinition> properties = new HashMap<String, PropertyDefinition>();
        PropertyDefinition keyProperty = null;
        KeyConfig keyConfig = this.config != null ? this.config.getKey() : null;
        for (Method thisMethod : this.clazz.getDeclaredMethods()) {
            PropertyDefinition thisProperty;
            String name;
            boolean isKeyViaConfig;
            String methodName = thisMethod.getName();
            ColumnConfig getterConfig = this.getColumnFromGetter(methodName);
            ColumnConfig setterConfig = this.getColumnFromSetter(methodName);
            boolean bl = isKeyViaConfig = keyConfig != null && (keyConfig.isGetter(methodName) || keyConfig.isSetter(methodName));
            if (thisMethod.isAnnotationPresent(DingoKey.class) || isKeyViaConfig) {
                if (keyProperty == null) {
                    keyProperty = new PropertyDefinition("_key_", this.mapper);
                }
                if (isKeyViaConfig) {
                    if (keyConfig.isGetter(methodName)) {
                        keyProperty.setGetter(thisMethod);
                    } else {
                        keyProperty.setSetter(thisMethod);
                    }
                } else {
                    DingoKey key = thisMethod.getAnnotation(DingoKey.class);
                    if (key.setter()) {
                        keyProperty.setSetter(thisMethod);
                    } else {
                        keyProperty.setGetter(thisMethod);
                    }
                }
            }
            if (thisMethod.isAnnotationPresent(DingoGetter.class) || getterConfig != null) {
                String getterName = getterConfig != null ? getterConfig.getName() : thisMethod.getAnnotation(DingoGetter.class).name();
                name = ParserUtils.getInstance().get(ParserUtils.getInstance().get(getterName));
                thisProperty = this.getOrCreateProperty(name, properties);
                thisProperty.setGetter(thisMethod);
            }
            if (!thisMethod.isAnnotationPresent(DingoSetter.class) && setterConfig == null) continue;
            String setterName = setterConfig != null ? setterConfig.getName() : thisMethod.getAnnotation(DingoSetter.class).name();
            name = ParserUtils.getInstance().get(ParserUtils.getInstance().get(setterName));
            thisProperty = this.getOrCreateProperty(name, properties);
            thisProperty.setSetter(thisMethod);
        }
        for (String thisPropertyName : properties.keySet()) {
            PropertyDefinition thisProperty = (PropertyDefinition)properties.get(thisPropertyName);
            thisProperty.validate(this.clazz.getName(), this.config, false);
            if (this.values.get(thisPropertyName) != null) {
                throw new DingoClientException("Class " + this.clazz.getName() + " cannot define the mapped name " + thisPropertyName + " more than once");
            }
            TypeUtils.AnnotatedType annotatedType = new TypeUtils.AnnotatedType(this.config, thisProperty.getGetter());
            TypeMapper typeMapper = TypeUtils.getMapper(thisProperty.getType(), annotatedType, this.mapper);
            ValueType.MethodValue value = new ValueType.MethodValue(thisProperty, typeMapper, annotatedType);
            this.values.put(thisPropertyName, value);
        }
    }

    private void loadFieldsFromClass() {
        KeyConfig keyConfig = this.config != null ? this.config.getKey() : null;
        String keyField = keyConfig == null ? null : keyConfig.getField();
        for (Field thisField : this.clazz.getDeclaredFields()) {
            String columnName;
            boolean isKey = false;
            ColumnConfig thisBin = this.getColumnFromField(thisField);
            if (thisField.isAnnotationPresent(DingoKey.class) || !StringUtils.isBlank(keyField) && keyField.equals(thisField.getName())) {
                if (thisField.isAnnotationPresent(DingoExclude.class) || thisBin != null && thisBin.isExclude() != null && thisBin.isExclude().booleanValue()) {
                    throw new DingoClientException("Class " + this.clazz.getName() + " cannot have a field which is both a key and excluded.");
                }
                TypeUtils.AnnotatedType annotatedType = new TypeUtils.AnnotatedType(this.config, thisField);
                TypeMapper typeMapper = TypeUtils.getMapper(thisField.getType(), annotatedType, this.mapper);
                this.keys.add(new ValueType.FieldValue(thisField, typeMapper, annotatedType));
                isKey = true;
            }
            if (thisField.isAnnotationPresent(DingoExclude.class) || thisBin != null && thisBin.isExclude() != null && thisBin.isExclude().booleanValue() || !this.mapAll && !thisField.isAnnotationPresent(DingoColumn.class) && thisBin == null) continue;
            DingoColumn dingoColumn = thisField.getAnnotation(DingoColumn.class);
            String string = columnName = dingoColumn == null ? null : ParserUtils.getInstance().get(dingoColumn.name());
            if (thisBin != null && !StringUtils.isBlank(thisBin.getDerivedName())) {
                columnName = thisBin.getDerivedName();
            }
            String name = StringUtils.isBlank(columnName) ? thisField.getName() : columnName;
            if (isKey) {
                this.keysName.add(name);
            }
            if (this.values.get(name) != null) {
                throw new DingoClientException("Class " + this.clazz.getName() + " cannot define the mapped name " + name + " more than once");
            }
            if (dingoColumn != null && dingoColumn.useAccessors() || thisBin != null && thisBin.getUseAccessors() != null && thisBin.getUseAccessors().booleanValue()) {
                this.validateAccessorsForField(name, thisField);
                continue;
            }
            thisField.setAccessible(true);
            TypeUtils.AnnotatedType annotatedType = new TypeUtils.AnnotatedType(this.config, thisField);
            TypeMapper typeMapper = TypeUtils.getMapper(thisField.getType(), annotatedType, this.mapper);
            ValueType.FieldValue valueType = new ValueType.FieldValue(thisField, typeMapper, annotatedType);
            this.values.put(name, valueType);
        }
    }

    private Method findMethodWithNameAndParams(String name, Class<?> ... params) {
        try {
            Method method = this.clazz.getDeclaredMethod(name, params);
            return method;
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    private void validateAccessorsForField(String columnName, Field thisField) {
        String fieldName = thisField.getName();
        String methodNameBase = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        String getterName = "get" + methodNameBase;
        String setterName = "set" + methodNameBase;
        Method getter = this.findMethodWithNameAndParams(getterName, new Class[0]);
        if (getter == null) {
            throw new DingoClientException(String.format("Expected to find getter for field %s on class %s due to it being configured to useAccessors, but no method with the signature \"%s %s()\" was found", fieldName, this.clazz.getSimpleName(), thisField.getType().getSimpleName(), getterName));
        }
        Method setter = this.findMethodWithNameAndParams(setterName, thisField.getType());
        if (setter == null) {
            setter = this.findMethodWithNameAndParams(setterName, thisField.getType(), Key.class);
        }
        if (setter == null) {
            setter = this.findMethodWithNameAndParams(setterName, thisField.getType(), Value.class);
        }
        if (setter == null) {
            throw new DingoClientException(String.format("Expected to find setter for field %s on class %s due to it being configured to useAccessors, but no method with the name \"%s\" was found", fieldName, this.clazz.getSimpleName(), setterName));
        }
        TypeUtils.AnnotatedType annotatedType = new TypeUtils.AnnotatedType(this.config, thisField);
        TypeMapper typeMapper = TypeUtils.getMapper(thisField.getType(), annotatedType, this.mapper);
        PropertyDefinition property = new PropertyDefinition(columnName, this.mapper);
        property.setGetter(getter);
        property.setSetter(setter);
        property.validate(this.clazz.getName(), this.config, false);
        ValueType.MethodValue value = new ValueType.MethodValue(property, typeMapper, annotatedType);
        this.values.put(columnName, value);
    }

    public Object translateKeyToDingoKey(TypeMapper typeMapper, Object key) {
        return typeMapper.toDingoFormat(key);
    }

    private Object internalGetKey(Object object) throws ReflectiveOperationException {
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (ValueType key : this.keys) {
            if (key == null) continue;
            keyList.add(this.translateKeyToDingoKey(key.getTypeMapper(), key.get(object)));
        }
        return keyList;
    }

    public Object getKey(Object object) {
        try {
            Object key = this.internalGetKey(object);
            if (key instanceof List && ((List)key).size() == 0) {
                throw new DingoClientException("Null key from annotated object of class " + this.clazz.getSimpleName() + ". Did you forget an @DingoKey annotation?");
            }
            return key;
        }
        catch (ReflectiveOperationException re) {
            throw new DingoClientException(re);
        }
    }

    private void internalSetKey(Object[] objects, Object[] values) throws ReflectiveOperationException {
        if (this.keys != null && this.keys.size() > 0) {
            for (int i = 0; i < this.keys.size(); ++i) {
                this.keys.get(i).set(objects[i], values[i]);
            }
        } else if (this.superClazz != null) {
            super.internalSetKey(objects, values);
        }
    }

    public void setKey(Object[] object, Object[] value) {
        try {
            this.internalSetKey(object, value);
        }
        catch (ReflectiveOperationException re) {
            throw new DingoClientException(re);
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName.toUpperCase();
    }

    private boolean contains(String[] names, String thisName) {
        if (names == null || names.length == 0) {
            return true;
        }
        if (thisName == null) {
            return false;
        }
        for (String aName : names) {
            if (!thisName.equals(aName)) continue;
            return true;
        }
        return false;
    }

    public Column[] getColumns(Object instance, boolean allowNullColumns) {
        Column[] columns = new Column[this.columnCnt];
        try {
            int index = 0;
            ClassCacheEntry<?> thisClass = this;
            while (thisClass != null) {
                Set<String> keys = thisClass.values.keySet();
                for (String name : keys) {
                    ValueType value = thisClass.values.get(name);
                    Object javaValue = value.get(instance);
                    Object dingoValue = value.getTypeMapper().toDingoFormat(javaValue);
                    if (dingoValue == null && !allowNullColumns) continue;
                    if (dingoValue instanceof TreeMap) {
                        TreeMap treeMap = (TreeMap)dingoValue;
                        columns[index++] = new Column(name, new ArrayList(treeMap.entrySet()), MapOrder.KEY_ORDERED);
                        continue;
                    }
                    columns[index++] = new Column(name, dingoValue);
                }
                thisClass = thisClass.superClazz;
            }
            return columns;
        }
        catch (ReflectiveOperationException ref) {
            throw new DingoClientException(ref);
        }
    }

    public Column[] getColumns(Object newInstance, Record oldRecord, boolean allowNullColumns, String[] includeColumns) {
        try {
            Column[] columns = new Column[this.columnCnt];
            int index = 0;
            ClassCacheEntry<?> thisClass = this;
            while (thisClass != null) {
                Set<String> keys = thisClass.values.keySet();
                for (String name : keys) {
                    Object dingoValue = null;
                    if (!super.contains(includeColumns, name)) {
                        dingoValue = oldRecord.getValue(name);
                    } else {
                        ValueType value = thisClass.values.get(name);
                        Object javaValue = value.get(newInstance);
                        dingoValue = value.getTypeMapper().toDingoFormat(javaValue);
                    }
                    if (dingoValue == null && !allowNullColumns) continue;
                    if (dingoValue instanceof TreeMap) {
                        TreeMap treeMap = (TreeMap)dingoValue;
                        columns[index++] = new Column(name, new ArrayList(treeMap.entrySet()), MapOrder.KEY_ORDERED);
                        continue;
                    }
                    columns[index++] = new Column(name, dingoValue);
                }
                thisClass = thisClass.superClazz;
            }
            return columns;
        }
        catch (ReflectiveOperationException ref) {
            throw new DingoClientException(ref);
        }
    }

    public boolean isAllColumnsValid(String[] includeColumns) {
        Set<String> keys = this.values.keySet();
        for (String inColumn : includeColumns) {
            if (keys.contains(inColumn)) continue;
            return true;
        }
        return false;
    }

    private SqlTypeInfo getSqlTypeInfo(String inputJavaType, Integer precision, Integer scale, String defaultValue) {
        String typeName = TypeUtils.getSqlType(inputJavaType);
        return new SqlTypeInfo(typeName, precision, scale, defaultValue);
    }

    private SqlTypeInfo getSqlTypeInfo(String inputJavaType) {
        String typeName = TypeUtils.getSqlType(inputJavaType);
        return new SqlTypeInfo(typeName);
    }

    public TableDefinition getTableDefinition(String tableName) {
        TableDefinition tableDefinition = new TableDefinition(tableName);
        List keyFieldList = this.keys.stream().map(v -> ((ValueType.FieldValue)v).getField()).collect(Collectors.toList());
        for (Field thisField : this.clazz.getDeclaredFields()) {
            boolean isKey = false;
            if (thisField.isAnnotationPresent(DingoKey.class)) {
                if (thisField.isAnnotationPresent(DingoExclude.class)) {
                    throw new DingoClientException("Class " + this.clazz.getName() + " cannot have a field which is both a key and excluded.");
                }
                if (this.keys != null && keyFieldList.contains(thisField)) {
                    isKey = true;
                }
            }
            if (thisField.isAnnotationPresent(DingoExclude.class)) continue;
            String javaTypeName = thisField.getType().getSimpleName();
            SqlTypeInfo sqlTypeInfo = this.getSqlTypeInfo(javaTypeName);
            String columnName = thisField.getName();
            String elementTypeName = null;
            if (thisField.isAnnotationPresent(DingoColumn.class)) {
                DingoColumn dingoColumn = thisField.getAnnotation(DingoColumn.class);
                String sqlTypeName = TypeUtils.getSqlType(javaTypeName);
                sqlTypeInfo = new SqlTypeInfo(sqlTypeName, dingoColumn);
                if (dingoColumn.name() != null && !dingoColumn.name().isEmpty()) {
                    columnName = dingoColumn.name();
                }
                if (dingoColumn.elementType() != null && !dingoColumn.elementType().isEmpty()) {
                    elementTypeName = TypeUtils.getSqlType(dingoColumn.elementType());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Input JavaTypeName is:{}, sqlTypeInfo:{}, columnName:{}, elementTypeName:{}", javaTypeName, sqlTypeInfo, thisField.getType().toGenericString(), elementTypeName);
            }
            ColumnDefinition columnDefinition = ColumnDefinition.getInstance(columnName, sqlTypeInfo.getSqlTypeName(), elementTypeName, sqlTypeInfo.getPrecision(), sqlTypeInfo.getScale(), isKey, isKey, sqlTypeInfo.getDefaultValue());
            tableDefinition.addColumn(columnDefinition);
        }
        return tableDefinition;
    }

    public Map<String, Object> getMap(Object instance, boolean needsType) {
        try {
            HashMap<String, Object> results = new HashMap<String, Object>();
            ClassCacheEntry<?> thisClass = this;
            if (needsType) {
                results.put(TYPE_NAME, this.getShortenedClassName());
            }
            while (thisClass != null) {
                for (String name : thisClass.values.keySet()) {
                    ValueType value = thisClass.values.get(name);
                    Object javaValue = value.get(instance);
                    Object dingoValue = value.getTypeMapper().toDingoFormat(javaValue);
                    results.put(name, dingoValue);
                }
                thisClass = thisClass.superClazz;
            }
            return results;
        }
        catch (ReflectiveOperationException ref) {
            throw new DingoClientException(ref);
        }
    }

    private void addDataFromValueName(String name, Object instance, ClassCacheEntry<?> thisClass, List<Object> results) throws ReflectiveOperationException {
        ValueType value = thisClass.values.get(name);
        Object javaValue = value.get(instance);
        Object dingoValue = value.getTypeMapper().toDingoFormat(javaValue);
        results.add(dingoValue);
    }

    private boolean isKeyField(String name) {
        return this.keysName.contains(name);
    }

    public List<Object> getList(Object instance, boolean skipKey, boolean needsType) {
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            ArrayList<String> versionsToAdd = new ArrayList<String>();
            ClassCacheEntry<?> thisClass = this;
            while (thisClass != null) {
                if (thisClass.version > 1) {
                    versionsToAdd.add(0, VERSION_PREFIX + thisClass.version);
                }
                if (thisClass.ordinals != null) {
                    for (int i = 1; i <= thisClass.ordinals.size(); ++i) {
                        String name = thisClass.ordinals.get(i);
                        if (skipKey && super.isKeyField(name)) continue;
                        super.addDataFromValueName(name, instance, thisClass, results);
                    }
                }
                for (String name : thisClass.values.keySet()) {
                    if (thisClass.fieldsWithOrdinals != null && thisClass.fieldsWithOrdinals.contains(name) || skipKey && super.isKeyField(name)) continue;
                    super.addDataFromValueName(name, instance, thisClass, results);
                }
                thisClass = thisClass.superClazz;
            }
            results.addAll(versionsToAdd);
            if (needsType) {
                results.add(TYPE_PREFIX + this.getShortenedClassName());
            }
            return results;
        }
        catch (ReflectiveOperationException ref) {
            throw new DingoClientException(ref);
        }
    }

    public T constructAndHydrate(Map<String, Object> map) {
        return this.constructAndHydrate(null, map);
    }

    public T constructAndHydrate(Record record) {
        return this.constructAndHydrate(record, null);
    }

    public T constructAndHydrate(List<Object> list, boolean skipKey) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        try {
            Object obj;
            ClassCacheEntry<?> thisClass = this;
            int index = 0;
            int endIndex = list.size();
            if (!list.isEmpty() && (obj = list.get(endIndex - 1)) instanceof String && ((String)obj).startsWith(TYPE_PREFIX)) {
                String className = ((String)obj).substring(TYPE_PREFIX.length());
                thisClass = ClassCache.getInstance().getCacheEntryFromStoredName(className);
                if (thisClass == null) {
                    Class<?> typeClazz = Class.forName(className);
                    thisClass = ClassCache.getInstance().loadClass(typeClazz, this.mapper);
                }
                --endIndex;
            }
            T result = null;
            while (thisClass != null) {
                if (index >= endIndex) continue;
                Object lastValue = list.get(endIndex - 1);
                int recordVersion = 1;
                if (lastValue instanceof String && ((String)lastValue).startsWith(VERSION_PREFIX)) {
                    recordVersion = Integer.parseInt(((String)lastValue).substring(2));
                    --endIndex;
                }
                int objectVersion = thisClass.version;
                if (thisClass.ordinals != null) {
                    for (int i = 1; i <= thisClass.ordinals.size(); ++i) {
                        String name = thisClass.ordinals.get(i);
                        if (skipKey && super.isKeyField(name)) continue;
                        index = super.setValueByField(name, objectVersion, recordVersion, null, index, list, valueMap);
                    }
                }
                for (String name : thisClass.values.keySet()) {
                    if (thisClass.fieldsWithOrdinals != null && thisClass.fieldsWithOrdinals.contains(name) || skipKey && super.isKeyField(name)) continue;
                    index = super.setValueByField(name, objectVersion, recordVersion, null, index, list, valueMap);
                }
                if (result == null) {
                    result = (T)super.constructAndHydrateFromJavaMap(valueMap);
                } else {
                    for (String field : valueMap.keySet()) {
                        ValueType value = this.values.get(field);
                        value.set(result, valueMap.get(field));
                    }
                }
                valueMap.clear();
                thisClass = thisClass.superClazz;
            }
            return result;
        }
        catch (ReflectiveOperationException ref) {
            throw new DingoClientException(ref);
        }
    }

    private T constructAndHydrate(Record record, Map<String, Object> map) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        try {
            String className;
            ClassCacheEntry<?> thisClass = this;
            String string = className = map == null ? record.getString(TYPE_NAME) : (String)map.get(TYPE_NAME);
            if (className != null && (thisClass = ClassCache.getInstance().getCacheEntryFromStoredName(className)) == null) {
                Class<?> typeClazz = Class.forName(className);
                thisClass = ClassCache.getInstance().loadClass(typeClazz, this.mapper);
            }
            T result = null;
            while (thisClass != null) {
                ValueType value;
                for (String name : thisClass.values.keySet()) {
                    value = thisClass.values.get(name);
                    Object dingoValue = record == null ? map.get(name) : record.getValue(name);
                    valueMap.put(name, value.getTypeMapper().fromDingoFormat(dingoValue));
                }
                if (result == null) {
                    result = (T)super.constructAndHydrateFromJavaMap(valueMap);
                } else {
                    for (String field : valueMap.keySet()) {
                        value = thisClass.values.get(field);
                        value.set(result, valueMap.get(field));
                    }
                }
                valueMap.clear();
                thisClass = thisClass.superClazz;
            }
            return result;
        }
        catch (ReflectiveOperationException ref) {
            throw new DingoClientException(ref);
        }
    }

    public void hydrateFromRecord(Record record, Object instance) {
        this.hydrateFromRecordOrMap(record, null, instance);
    }

    public void hydrateFromMap(Map<String, Object> map, Object instance) {
        this.hydrateFromRecordOrMap(null, map, instance);
    }

    private void hydrateFromRecordOrMap(Record record, Map<String, Object> map, Object instance) {
        try {
            ClassCacheEntry<?> thisClass = this;
            while (thisClass != null) {
                for (String name : this.values.keySet()) {
                    ValueType value = this.values.get(name);
                    Object dingoValue = record == null ? map.get(name) : record.getValue(name);
                    value.set(instance, value.getTypeMapper().fromDingoFormat(dingoValue));
                }
                thisClass = thisClass.superClazz;
            }
        }
        catch (ReflectiveOperationException ref) {
            throw new DingoClientException(ref);
        }
    }

    private int setValueByField(String name, int objectVersion, int recordVersion, Object instance, int index, List<Object> list, Map<String, Object> map) throws ReflectiveOperationException {
        Object dingoValue;
        Object javaValue;
        ValueType value = this.values.get(name);
        TypeMapper typeMapper = value.getTypeMapper();
        Object object = javaValue = (dingoValue = list.get(index++)) == null ? null : typeMapper.fromDingoFormat(dingoValue);
        if (instance == null) {
            map.put(name, javaValue);
        } else {
            value.set(instance, javaValue);
        }
        return index;
    }

    public void hydrateFromList(List<Object> list, Object instance) {
        this.hydrateFromList(list, instance, false);
    }

    public void hydrateFromList(List<Object> list, Object instance, boolean skipKey) {
        try {
            int index = 0;
            int endIndex = list.size();
            ClassCacheEntry<?> thisClass = this;
            while (thisClass != null) {
                if (index >= endIndex) continue;
                Object lastValue = list.get(endIndex - 1);
                int recordVersion = 1;
                if (lastValue instanceof String && ((String)lastValue).startsWith(VERSION_PREFIX)) {
                    recordVersion = Integer.parseInt(((String)lastValue).substring(2));
                    --endIndex;
                }
                int objectVersion = thisClass.version;
                if (this.ordinals != null) {
                    for (int i = 1; i <= this.ordinals.size(); ++i) {
                        String name = this.ordinals.get(i);
                        if (skipKey && super.isKeyField(name)) continue;
                        index = super.setValueByField(name, objectVersion, recordVersion, instance, index, list, null);
                    }
                }
                for (String name : this.values.keySet()) {
                    if (this.fieldsWithOrdinals != null && thisClass.fieldsWithOrdinals.contains(name) || skipKey && super.isKeyField(name)) continue;
                    index = super.setValueByField(name, objectVersion, recordVersion, instance, index, list, null);
                }
                thisClass = thisClass.superClazz;
            }
        }
        catch (ReflectiveOperationException ref) {
            throw new DingoClientException(ref);
        }
    }

    private T constructAndHydrateFromJavaMap(Map<String, Object> javaValuesMap) throws ReflectiveOperationException {
        Object result;
        Object[] args;
        if (this.factoryConstructorMethod != null) {
            switch (this.factoryConstructorType) {
                case CLASS: {
                    args = new Object[]{this.clazz};
                    break;
                }
                case MAP: {
                    args = new Object[]{javaValuesMap};
                    break;
                }
                case CLASS_MAP: {
                    args = new Object[]{this.clazz, javaValuesMap};
                    break;
                }
                default: {
                    args = null;
                }
            }
            result = this.factoryConstructorMethod.invoke(null, args);
        } else {
            args = new Object[this.constructorParamBins.length];
            for (int i = 0; i < this.constructorParamBins.length; ++i) {
                args[i] = javaValuesMap.containsKey(this.constructorParamBins[i]) ? javaValuesMap.get(this.constructorParamBins[i]) : this.constructorParamDefaults[i];
                javaValuesMap.remove(this.constructorParamBins[i]);
            }
            result = this.constructor.newInstance(args);
        }
        LoadedObjectResolver.setObjectForCurrentKey(result);
        for (String field : javaValuesMap.keySet()) {
            ValueType value = this.values.get(field);
            Object object = javaValuesMap.get(field);
            if (object == null && value.getType().isPrimitive()) {
                object = PrimitiveDefaults.getDefaultValue(value.getType());
            }
            value.set(result, object);
        }
        return (T)result;
    }

    public ValueType getValueFromColumnName(String name) {
        return this.values.get(name);
    }

    public String toString() {
        String result = String.format("ClassCacheEntry<%s> (database=%s,table=%s,subclass=%b,shortName=%s)", this.getUnderlyingClass().getSimpleName(), this.database, this.tableName, this.isChildClass, this.shortenedClassName);
        return result;
    }

    private static enum FactoryMethodType {
        NO_PARAMS,
        CLASS,
        MAP,
        CLASS_MAP;

    }
}

