/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.utils;

import java.util.ArrayList;
import java.util.List;

public class DeferredObjectLoader {
    private static final ThreadLocal<List<DeferredObjectSetter>> threadLocalLoader = ThreadLocal.withInitial(ArrayList::new);

    public static void save(DeferredObjectSetter object) {
        threadLocalLoader.get().add(object);
    }

    public static void clear() {
        threadLocalLoader.get().clear();
    }

    public static List<DeferredObjectSetter> get() {
        return threadLocalLoader.get();
    }

    public static void add(DeferredObjectSetter deferredSetter) {
        threadLocalLoader.get().add(deferredSetter);
    }

    public static List<DeferredObjectSetter> getAndClear() {
        List<DeferredObjectSetter> localArray = threadLocalLoader.get();
        ArrayList<DeferredObjectSetter> setters = new ArrayList<DeferredObjectSetter>(localArray);
        localArray.clear();
        return setters;
    }

    public static class DeferredObjectSetter {
        private final DeferredSetter setter;
        private final DeferredObject object;

        public DeferredObjectSetter(DeferredSetter setter, DeferredObject object) {
            this.setter = setter;
            this.object = object;
        }

        public DeferredSetter getSetter() {
            return this.setter;
        }

        public DeferredObject getObject() {
            return this.object;
        }
    }

    public static class DeferredObject {
        private final Object key;
        private final Class<?> type;
        private final boolean isDigest;

        public DeferredObject(Object key, Class<?> type2, boolean isDigest) {
            this.key = key;
            this.type = type2;
            this.isDigest = isDigest;
        }

        public Object getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean isDigest() {
            return this.isDigest;
        }
    }

    public static interface DeferredSetter {
        public void setValue(Object var1);
    }
}

