/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.utils;

import io.dingodb.sdk.annotation.FromDingo;
import io.dingodb.sdk.annotation.ToDingo;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.mappers.TypeMapper;
import io.dingodb.sdk.utils.TypeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GenericTypeMapper
extends TypeMapper {
    private final Class<?> mappedClass;
    private final Object converter;
    private Method toDingo;
    private Method fromDingo;

    public GenericTypeMapper(Object converter) {
        for (Method method : converter.getClass().getMethods()) {
            if (method.isAnnotationPresent(ToDingo.class)) {
                if (this.toDingo != null) {
                    throw new DingoClientException(String.format("Multiple methods annotated with @FromDingo: %s, %s", this.toDingo.toGenericString(), method.toGenericString()));
                }
                this.toDingo = method;
            }
            if (!method.isAnnotationPresent(FromDingo.class)) continue;
            if (this.fromDingo != null) {
                throw new DingoClientException(String.format("Multiple methods annotated with @FromDingo: %s, %s", this.fromDingo.toGenericString(), method.toGenericString()));
            }
            this.fromDingo = method;
        }
        this.converter = converter;
        this.mappedClass = this.validateAndGetClass();
    }

    public Class<?> getMappedClass() {
        return this.mappedClass;
    }

    private Class<?> validateAndGetClass() {
        if (this.toDingo == null) {
            throw new DingoClientException(String.format("Converter class %s must have a @ToDingo annotated method.", this.converter.getClass()));
        }
        if (this.toDingo.getParameterCount() != 1) {
            throw new DingoClientException(String.format("@ToDingo method on Converter class %s must take 1 argument", this.converter.getClass()));
        }
        if (TypeUtils.isVoidType(this.toDingo.getReturnType())) {
            throw new DingoClientException(String.format("@ToDingo method on Converter class %s cannot return void", this.converter.getClass()));
        }
        this.toDingo.setAccessible(true);
        if (this.fromDingo == null) {
            throw new DingoClientException(String.format("Converter class %s must have a @FromDingo annotated method.", this.converter.getClass()));
        }
        if (this.fromDingo.getParameterCount() != 1) {
            throw new DingoClientException(String.format("@FromDingo method on Converter class %s must take 1 argument", this.converter.getClass()));
        }
        if (TypeUtils.isVoidType(this.fromDingo.getReturnType())) {
            throw new DingoClientException(String.format("@FromDingo method on Converter class %s cannot return void", this.converter.getClass()));
        }
        this.fromDingo.setAccessible(true);
        if (!this.toDingo.getParameters()[0].getType().equals(this.fromDingo.getReturnType())) {
            throw new DingoClientException(String.format("@FromDingo on Converter class %s returns %s, but the @ToDingo takes %s. These should be same", this.converter.getClass().getSimpleName(), this.fromDingo.getReturnType().getSimpleName(), this.toDingo.getParameters()[0].getType().getSimpleName()));
        }
        if (!this.fromDingo.getParameters()[0].getType().equals(this.toDingo.getReturnType())) {
            throw new DingoClientException(String.format("@ToDingo method on Converter class %s returns %s, but the @FromDingo method takes %s. These should be the same class", this.converter.getClass().getSimpleName(), this.toDingo.getReturnType().getSimpleName(), this.fromDingo.getParameters()[0].getType().getSimpleName()));
        }
        return this.fromDingo.getReturnType();
    }

    @Override
    public Object toDingoFormat(Object value) {
        try {
            return this.toDingo.invoke(this.converter, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new DingoClientException(e);
        }
    }

    @Override
    public Object fromDingoFormat(Object value) {
        return value;
    }
}

