/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.utils;

public class ParserUtils {
    private static final ParserUtils instance = new ParserUtils();

    public static ParserUtils getInstance() {
        return instance;
    }

    private ParserUtils() {
    }

    public String get(String value) {
        return this.parseString(value);
    }

    private String parseString(String value) {
        if (value == null || value.length() <= 3) {
            return value;
        }
        if ((value.startsWith("${") || value.startsWith("#{")) && value.endsWith("}")) {
            String[] values = value.substring(2, value.length() - 1).split(":");
            String translatedValue = value.startsWith("${") ? System.getProperty(values[0]) : System.getenv(values[0]);
            if (translatedValue != null) {
                return translatedValue;
            }
            if (values.length > 1) {
                return values[1];
            }
            return null;
        }
        return value;
    }
}

