/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.utils;

public final class ResultCode {
    public static final int MAX_RETRIES_EXCEEDED = -1000;
    public static final int SERIALIZE_ERROR = -1001;
    public static final int SERVER_NOT_AVAILABLE = -1002;
    public static final int NO_MORE_CONNECTIONS = -1003;
    public static final int PARSE_ERROR = -1004;
    public static final int CLIENT_ERROR = -1005;
    public static final int OK = 0;
    public static final int SERVER_ERROR = 1000;
    public static final int PARTITION_UNAVAILABLE = 1001;
    public static final int KEY_NOT_FOUND_ERROR = 2001;
    public static final int PARAMETER_ERROR_INVALID_KEYCNT = 2002;
    public static final int PARAMETER_ERROR_INVALID_COLUMNCNT = 2003;
    public static final int KEY_EXISTS_ERROR = 2004;
    public static final int KEY_MISMATCH = 2005;
    public static final int INVALID_TABLE_NAME = 2006;
    public static final int NULL_KEY_ERROR = 2007;
    public static final int TIMEOUT = 3000;

    public static String getResultString(int resultCode) {
        switch (resultCode) {
            case -1000: {
                return "Max retries exceeded";
            }
            case -1001: {
                return "Serialize error";
            }
            case -1002: {
                return "Server not available";
            }
            case -1003: {
                return "No more available connections";
            }
            case -1004: {
                return "Parse error";
            }
            case -1005: {
                return "Client error";
            }
            case 0: {
                return "ok";
            }
            case 1000: {
                return "Server error";
            }
            case 2001: {
                return "Key not found";
            }
            case 2002: {
                return "Input key count is not equal";
            }
            case 2003: {
                return "Input column count is not equal";
            }
            case 2004: {
                return "Key already exists";
            }
            case 1001: {
                return "Partition unavailable";
            }
            case 3000: {
                return "Timeout";
            }
            case 2005: {
                return "Key mismatch";
            }
            case 2006: {
                return "Namespace not found";
            }
            case 2007: {
                return "Input primary key is null";
            }
        }
        return "";
    }
}

