/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.utils;

import io.dingodb.sdk.common.Key;
import java.util.ArrayDeque;
import java.util.Deque;

public class ThreadLocalKeySaver {
    private static final ThreadLocal<Deque<Key>> threadLocalKeys = ThreadLocal.withInitial(ArrayDeque::new);

    public static void save(Key key) {
        threadLocalKeys.get().addLast(key);
    }

    public static void clear() {
        threadLocalKeys.get().removeLast();
    }

    public static Key get() {
        Deque<Key> keys = threadLocalKeys.get();
        if (keys.isEmpty()) {
            return null;
        }
        return keys.getLast();
    }
}

