/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.utils;

import io.dingodb.sdk.annotation.DingoEmbed;
import io.dingodb.sdk.annotation.DingoEnum;
import io.dingodb.sdk.annotation.DingoRecord;
import io.dingodb.sdk.client.IBaseDingoMapper;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.configuration.ClassConfig;
import io.dingodb.sdk.configuration.ColumnConfig;
import io.dingodb.sdk.configuration.EmbedConfig;
import io.dingodb.sdk.mappers.ArrayMapper;
import io.dingodb.sdk.mappers.BooleanMapper;
import io.dingodb.sdk.mappers.ByteMapper;
import io.dingodb.sdk.mappers.CharacterMapper;
import io.dingodb.sdk.mappers.DateMapper;
import io.dingodb.sdk.mappers.DefaultMapper;
import io.dingodb.sdk.mappers.EnumMapper;
import io.dingodb.sdk.mappers.FloatMapper;
import io.dingodb.sdk.mappers.InstantMapper;
import io.dingodb.sdk.mappers.IntMapper;
import io.dingodb.sdk.mappers.ListMapper;
import io.dingodb.sdk.mappers.MapMapper;
import io.dingodb.sdk.mappers.ObjectEmbedMapper;
import io.dingodb.sdk.mappers.SetMapper;
import io.dingodb.sdk.mappers.ShortMapper;
import io.dingodb.sdk.mappers.TimeMapper;
import io.dingodb.sdk.mappers.TimestampMapper;
import io.dingodb.sdk.mappers.TypeMapper;
import io.dingodb.sdk.utils.ClassCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TypeUtils {
    private static final Map<Class<?>, TypeMapper> mappers = new ConcurrentHashMap();

    public static TypeMapper addTypeMapper(Class<?> clazz, TypeMapper mapper) {
        TypeMapper returnValue = mappers.get(clazz);
        mappers.put(clazz, mapper);
        return returnValue;
    }

    private static TypeMapper getMapper(Class<?> clazz, AnnotatedType type2, IBaseDingoMapper mapper, boolean isForSubType) {
        if (clazz == null) {
            return null;
        }
        TypeMapper typeMapper = mappers.get(clazz);
        boolean addToMap = true;
        if (typeMapper == null) {
            if (Date.class.isAssignableFrom(clazz)) {
                typeMapper = Time.class.isAssignableFrom(clazz) ? new TimeMapper() : (Timestamp.class.isAssignableFrom(clazz) ? new TimestampMapper() : new DateMapper());
            }
            if (Instant.class.isAssignableFrom(clazz)) {
                typeMapper = new InstantMapper();
            } else if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
                typeMapper = new ByteMapper();
            } else if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
                typeMapper = new CharacterMapper();
            } else if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
                typeMapper = new ShortMapper();
            } else if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
                typeMapper = new IntMapper();
            } else if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
                typeMapper = new BooleanMapper();
            } else if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
                typeMapper = new FloatMapper();
            } else if (clazz.isEnum()) {
                DingoEnum dingoEnum;
                String dingoEnumField = "";
                if (type2 != null && type2.getAnnotations() != null && (dingoEnum = type2.getAnnotation(DingoEnum.class)) != null) {
                    dingoEnumField = dingoEnum.enumField();
                }
                typeMapper = new EnumMapper(clazz, dingoEnumField);
                addToMap = false;
            } else if (clazz.isArray()) {
                Class<?> elementType = clazz.getComponentType();
                if (TypeUtils.isByteType(elementType)) {
                    typeMapper = new DefaultMapper();
                } else {
                    boolean allowBatch = true;
                    TypeMapper subMapper = TypeUtils.getMapper(elementType, type2, mapper, true);
                    typeMapper = new ArrayMapper(elementType, subMapper, allowBatch);
                    addToMap = false;
                }
            } else if (Set.class.isAssignableFrom(clazz)) {
                Class elementType;
                ParameterizedType paramType = type2.getParameterizedType();
                Type[] types = paramType.getActualTypeArguments();
                Class clazz2 = elementType = types[0] instanceof Class ? (Class)types[0] : null;
                if (TypeUtils.isByteType(elementType)) {
                    typeMapper = new DefaultMapper();
                } else {
                    TypeMapper subMapper = TypeUtils.getMapper(elementType, type2, mapper, true);
                    typeMapper = new SetMapper(elementType, subMapper);
                    addToMap = false;
                }
            } else if (Map.class.isAssignableFrom(clazz)) {
                if (type2.isParameterizedType()) {
                    ParameterizedType paramType = type2.getParameterizedType();
                    Type[] types = paramType.getActualTypeArguments();
                    if (types.length != 2) {
                        String errorMsg = String.format("Type %s is a parameterized type as expected,  but has %d type parameters, not the expected 2", clazz.getName(), types.length);
                        throw new DingoClientException(errorMsg);
                    }
                    Class keyClazz = (Class)types[0];
                    Class itemClazz = (Class)types[1];
                    TypeMapper keyMapper = TypeUtils.getMapper(keyClazz, type2, mapper, true);
                    TypeMapper itemMapper = TypeUtils.getMapper(itemClazz, type2, mapper, true);
                    typeMapper = new MapMapper(clazz, keyClazz, itemClazz, keyMapper, itemMapper, mapper);
                } else {
                    typeMapper = new MapMapper(clazz, null, null, null, null, mapper);
                }
                addToMap = false;
            } else if (List.class.isAssignableFrom(clazz)) {
                ColumnConfig columnConfig;
                DingoEmbed embed;
                DingoEmbed.EmbedType embedType = DingoEmbed.EmbedType.DEFAULT;
                boolean saveKey = true;
                boolean allowBatch = true;
                if (type2 != null && type2.getAnnotations() != null && (embed = type2.getAnnotation(DingoEmbed.class)) != null) {
                    embedType = embed.type();
                    saveKey = embed.saveKey();
                }
                ColumnConfig columnConfig2 = columnConfig = type2 != null ? type2.getColumnConfig() : null;
                if (columnConfig != null && columnConfig.getEmbed() != null) {
                    if (columnConfig.getEmbed().getSaveKey() != null) {
                        saveKey = columnConfig.getEmbed().getSaveKey();
                    }
                    if (columnConfig.getEmbed().getType() != null) {
                        embedType = columnConfig.getEmbed().getType();
                    }
                }
                if (type2 != null && type2.isParameterizedType()) {
                    ParameterizedType paramType = type2.getParameterizedType();
                    Type[] types = paramType.getActualTypeArguments();
                    if (types.length != 1) {
                        String errorMsg = String.format("Type %s is a parameterized type as expected,but has %d type parameters, not the expected 1", clazz.getName(), types.length);
                        throw new DingoClientException(errorMsg);
                    }
                    Class subClazz = (Class)types[0];
                    TypeMapper subMapper = TypeUtils.getMapper(subClazz, type2, mapper, true);
                    typeMapper = new ListMapper(clazz, subClazz, subMapper, mapper, embedType, saveKey, allowBatch);
                } else {
                    typeMapper = new ListMapper(clazz, null, null, mapper, embedType, saveKey, allowBatch);
                }
                addToMap = false;
            } else if (clazz.isAnnotationPresent(DingoRecord.class) || ClassCache.getInstance().hasClassConfig(clazz)) {
                boolean throwError = false;
                if (type2 != null) {
                    ColumnConfig columnConfig = type2.getColumnConfig();
                    if (columnConfig != null && columnConfig.getEmbed() != null) {
                        if (columnConfig.getEmbed() != null) {
                            DingoEmbed.EmbedType embedType;
                            EmbedConfig embedConfig = columnConfig.getEmbed();
                            DingoEmbed.EmbedType embedType2 = embedType = isForSubType ? embedConfig.getElementType() : embedConfig.getType();
                            if (embedType == null) {
                                embedType = DingoEmbed.EmbedType.MAP;
                            }
                            boolean saveKey = embedConfig.getSaveKey() != null;
                            boolean skipKey = isForSubType && embedConfig.getType() == DingoEmbed.EmbedType.MAP && embedConfig.getElementType() == DingoEmbed.EmbedType.LIST && !saveKey;
                            typeMapper = new ObjectEmbedMapper(clazz, embedType, mapper, skipKey);
                            addToMap = false;
                        }
                    } else if (type2.getAnnotations() != null) {
                        for (Annotation annotation : type2.getAnnotations()) {
                            if (!annotation.annotationType().equals(DingoEmbed.class)) continue;
                            DingoEmbed embed = (DingoEmbed)annotation;
                            if (typeMapper != null) {
                                throwError = true;
                                break;
                            }
                            DingoEmbed.EmbedType embedType = isForSubType ? embed.elementType() : embed.type();
                            boolean skipKey = isForSubType && embed.type() == DingoEmbed.EmbedType.MAP && embed.elementType() == DingoEmbed.EmbedType.LIST && !embed.saveKey();
                            typeMapper = new ObjectEmbedMapper(clazz, embedType, mapper, skipKey);
                            addToMap = false;
                        }
                    }
                }
                if (throwError) {
                    String errorMsg = String.format("A class with a reference to %s specifies multiple annotations for storing the reference", clazz.getName());
                    throw new DingoClientException(errorMsg);
                }
            }
            if (typeMapper == null) {
                typeMapper = new DefaultMapper();
            }
            if (addToMap) {
                mappers.put(clazz, typeMapper);
            }
        }
        return typeMapper;
    }

    public static TypeMapper getMapper(Class<?> clazz, AnnotatedType type2, IBaseDingoMapper mapper) {
        return TypeUtils.getMapper(clazz, type2, mapper, false);
    }

    public static String bytesToHexString(byte[] buf) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            sb.append(String.format("%02x", buf[i]));
        }
        return sb.toString();
    }

    public static String bytesToHexString(byte[] buf, int offset, int length) {
        StringBuilder sb = new StringBuilder(length * 2);
        for (int i = offset; i < length; ++i) {
            sb.append(String.format("%02x", buf[i]));
        }
        return sb.toString();
    }

    public static boolean isByteType(Class<?> clazz) {
        return Byte.class.equals(clazz) || Byte.TYPE.equals(clazz);
    }

    public static boolean isVoidType(Class<?> clazz) {
        return clazz == null || Void.class.equals(clazz) || Void.TYPE.equals(clazz);
    }

    public static boolean isDingoNativeType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Long.TYPE.equals(clazz) || Long.class.equals(clazz) || Double.TYPE.equals(clazz) || Double.class.equals(clazz) || String.class.equals(clazz);
    }

    public static void clear() {
        mappers.clear();
    }

    public static String getSqlType(String inputJavaType) {
        switch (inputJavaType.toLowerCase()) {
            case "boolean": 
            case "bool": {
                return "BOOLEAN";
            }
            case "int": 
            case "integer": {
                return "INTEGER";
            }
            case "long": {
                return "BIGINT";
            }
            case "double": {
                return "DOUBLE";
            }
            case "float": {
                return "FLOAT";
            }
            case "date": {
                return "DATE";
            }
            case "time": {
                return "TIME";
            }
            case "timestamp": {
                return "TIMESTAMP";
            }
            case "varchar": 
            case "string": {
                return "VARCHAR";
            }
            case "list": {
                return "ARRAY";
            }
            case "set": {
                return "MULTISET";
            }
            case "map": {
                return "ANY";
            }
        }
        if (inputJavaType.contains("[]")) {
            return "ARRAY";
        }
        return "VARCHAR";
    }

    public static class AnnotatedType {
        private static final AnnotatedType defaultAnnotatedType = new AnnotatedType(null, null, null);
        private final Annotation[] annotations;
        private final ParameterizedType parameterizedType;
        private final ColumnConfig columnConfig;

        public static AnnotatedType getDefaultAnnotateType() {
            return defaultAnnotatedType;
        }

        private AnnotatedType(ColumnConfig columnConfig, Type type2, Annotation[] annotations) {
            this.columnConfig = columnConfig;
            this.annotations = annotations;
            this.parameterizedType = type2 instanceof ParameterizedType ? (ParameterizedType)type2 : null;
        }

        public AnnotatedType(ClassConfig config, Field field) {
            this(config == null ? null : config.getColumnByFieldName(field.getName()), field.getGenericType(), field.getAnnotations());
        }

        public AnnotatedType(ClassConfig config, Method getter) {
            this(config == null ? null : config.getColumnByGetterName(getter.getName()), getter.getGenericReturnType(), getter.getAnnotations());
        }

        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        public ColumnConfig getColumnConfig() {
            return this.columnConfig;
        }

        public ParameterizedType getParameterizedType() {
            return this.parameterizedType;
        }

        public boolean isParameterizedType() {
            return this.parameterizedType != null;
        }

        public <T> T getAnnotation(Class<T> clazz) {
            if (this.annotations == null) {
                return null;
            }
            for (Annotation annotation : this.annotations) {
                if (!annotation.annotationType().equals(clazz)) continue;
                return (T)annotation;
            }
            return null;
        }
    }
}

