/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.serial.io;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class BinaryDecoder {
    private final byte[] buf;
    private int forwardPosition = 0;
    private int reversePosition;

    public BinaryDecoder(byte[] buf) {
        this.buf = buf;
        this.reversePosition = buf.length - 1;
    }

    public Boolean readBoolean() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            ++this.forwardPosition;
            return null;
        }
        return this.buf[this.forwardPosition++] != 0;
    }

    public Short readShort() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            this.forwardPosition += 2;
            return null;
        }
        return (short)((this.buf[this.forwardPosition++] & 0xFF) << 8 | this.buf[this.forwardPosition++] & 0xFF);
    }

    public Short readKeyShort() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            this.forwardPosition += 2;
            return null;
        }
        return (short)((this.buf[this.forwardPosition++] & 0xFF ^ 0x80) << 8 | this.buf[this.forwardPosition++] & 0xFF);
    }

    public Integer readInt() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            this.forwardPosition += 4;
            return null;
        }
        return (this.buf[this.forwardPosition++] & 0xFF) << 24 | (this.buf[this.forwardPosition++] & 0xFF) << 16 | (this.buf[this.forwardPosition++] & 0xFF) << 8 | this.buf[this.forwardPosition++] & 0xFF;
    }

    public Integer readKeyInt() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            this.forwardPosition += 4;
            return null;
        }
        return (this.buf[this.forwardPosition++] & 0xFF ^ 0x80) << 24 | (this.buf[this.forwardPosition++] & 0xFF) << 16 | (this.buf[this.forwardPosition++] & 0xFF) << 8 | this.buf[this.forwardPosition++] & 0xFF;
    }

    public Float readFloat() throws IndexOutOfBoundsException {
        Integer i = this.readInt();
        if (i == null) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(i));
    }

    public Float readKeyFloat() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            this.forwardPosition += 4;
            return null;
        }
        int i = 0;
        i = (this.buf[this.forwardPosition] & 0xFF) > 128 ? (this.buf[this.forwardPosition++] & 0xFF ^ 0x80) << 24 | (this.buf[this.forwardPosition++] & 0xFF) << 16 | (this.buf[this.forwardPosition++] & 0xFF) << 8 | this.buf[this.forwardPosition++] & 0xFF : (~this.buf[this.forwardPosition++] & 0xFF) << 24 | (~this.buf[this.forwardPosition++] & 0xFF) << 16 | (~this.buf[this.forwardPosition++] & 0xFF) << 8 | ~this.buf[this.forwardPosition++] & 0xFF;
        return Float.valueOf(Float.intBitsToFloat(i));
    }

    public Long readLong() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            this.forwardPosition += 8;
            return null;
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l |= (long)(this.buf[this.forwardPosition++] & 0xFF);
        }
        return l;
    }

    public Long readKeyLong() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            this.forwardPosition += 8;
            return null;
        }
        long l = 0L;
        l |= (long)(this.buf[this.forwardPosition++] & 0xFF ^ 0x80);
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(this.buf[this.forwardPosition++] & 0xFF);
        }
        return l;
    }

    public Double readDouble() throws IndexOutOfBoundsException {
        Long l = this.readLong();
        if (l == null) {
            return null;
        }
        return Double.longBitsToDouble(l);
    }

    public Double readKeyDouble() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            this.forwardPosition += 8;
            return null;
        }
        long l = 0L;
        if ((this.buf[this.forwardPosition] & 0xFF) > 128) {
            l |= (long)(this.buf[this.forwardPosition++] & 0xFF ^ 0x80);
            for (int i = 0; i < 7; ++i) {
                l <<= 8;
                l |= (long)(this.buf[this.forwardPosition++] & 0xFF);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                l <<= 8;
                l |= (long)(~this.buf[this.forwardPosition++] & 0xFF);
            }
        }
        return Double.longBitsToDouble(l);
    }

    public byte[] readBytes() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int length = this.readLength();
        if (length > 0) {
            byte[] buf = new byte[length];
            System.arraycopy(this.buf, this.forwardPosition, buf, 0, length);
            this.skip(length);
            return buf;
        }
        return new byte[0];
    }

    public byte[] readKeyBytes() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int length = this.readKeyLength();
        if (length > 0) {
            int groupNum = length / 9;
            int reminderZero = 255 - this.buf[this.forwardPosition + length - 1] & 0xFF;
            int oriLength = groupNum * 8 - reminderZero;
            byte[] buf = new byte[oriLength];
            int bi = 0;
            buf[bi++] = this.buf[this.forwardPosition++];
            for (int i = 2; i < length - reminderZero; ++i) {
                if (i % 9 != 0) {
                    buf[bi++] = this.buf[this.forwardPosition++];
                    continue;
                }
                ++this.forwardPosition;
            }
            this.forwardPosition += reminderZero;
            ++this.forwardPosition;
            return buf;
        }
        return new byte[0];
    }

    public String readString() throws IndexOutOfBoundsException {
        byte[] buf = this.readBytes();
        if (buf == null) {
            return null;
        }
        if (buf.length == 0) {
            return "";
        }
        return new String(buf, StandardCharsets.UTF_8);
    }

    public String readKeyString() throws IndexOutOfBoundsException {
        byte[] buf = this.readKeyBytes();
        if (buf == null) {
            return null;
        }
        if (buf.length == 0) {
            return "";
        }
        return new String(buf, StandardCharsets.UTF_8);
    }

    public List<Boolean> readBooleanList() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int size = this.readLength();
        ArrayList<Boolean> list = new ArrayList<Boolean>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readBoolean());
        }
        return list;
    }

    public List<Short> readShortList() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int size = this.readLength();
        ArrayList<Short> list = new ArrayList<Short>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readShort());
        }
        return list;
    }

    public List<Integer> readIntegerList() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int size = this.readLength();
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readInt());
        }
        return list;
    }

    public List<Float> readFloatList() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int size = this.readLength();
        ArrayList<Float> list = new ArrayList<Float>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readFloat());
        }
        return list;
    }

    public List<Long> readLongList() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int size = this.readLength();
        ArrayList<Long> list = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readLong());
        }
        return list;
    }

    public List<Double> readDoubleList() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int size = this.readLength();
        ArrayList<Double> list = new ArrayList<Double>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readDouble());
        }
        return list;
    }

    public List<byte[]> readBytesList() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int size = this.readLength();
        ArrayList<byte[]> list = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readBytes());
        }
        return list;
    }

    public List<String> readStringList() throws IndexOutOfBoundsException {
        if (this.readIsNull()) {
            return null;
        }
        int size = this.readLength();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readString());
        }
        return list;
    }

    public void skipBytes() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(this.readLength());
        }
    }

    public void skipKeyBytes() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(this.readKeyLength());
        }
    }

    public void skipString() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(this.readLength());
        }
    }

    public void skipKeyString() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(this.readKeyLength());
        }
    }

    public void skipBooleanList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(2 * this.readLength());
        }
    }

    public void skipShortList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(3 * this.readLength());
        }
    }

    public void skipIntegerList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(5 * this.readLength());
        }
    }

    public void skipFloatList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(5 * this.readLength());
        }
    }

    public void skipLongList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(9 * this.readLength());
        }
    }

    public void skipDoubleList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(9 * this.readLength());
        }
    }

    public void skipBytesList() throws IndexOutOfBoundsException {
        int size;
        if (!this.readIsNull() && (size = this.readLength()) > 0) {
            for (int i = 0; i < size; ++i) {
                this.skipBytes();
            }
        }
    }

    public void skipStringList() throws IndexOutOfBoundsException {
        int size;
        if (!this.readIsNull() && (size = this.readLength()) > 0) {
            for (int i = 0; i < size; ++i) {
                this.skipString();
            }
        }
    }

    public int remainder() {
        return this.buf.length - this.forwardPosition;
    }

    private boolean readIsNull() throws IndexOutOfBoundsException {
        return this.buf[this.forwardPosition++] == 0;
    }

    private int readLength() throws IndexOutOfBoundsException {
        return (this.buf[this.forwardPosition++] & 0xFF) << 24 | (this.buf[this.forwardPosition++] & 0xFF) << 16 | (this.buf[this.forwardPosition++] & 0xFF) << 8 | this.buf[this.forwardPosition++] & 0xFF;
    }

    private int readKeyLength() throws IndexOutOfBoundsException {
        return (this.buf[this.reversePosition--] & 0xFF) << 24 | (this.buf[this.reversePosition--] & 0xFF) << 16 | (this.buf[this.reversePosition--] & 0xFF) << 8 | this.buf[this.reversePosition--] & 0xFF;
    }

    private void skipKeyLength() {
        this.reversePosition -= 4;
    }

    public void skip(int length) throws IndexOutOfBoundsException {
        this.forwardPosition += length;
    }
}

