/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.serial.io;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class BinaryEncoder {
    private byte[] buf;
    private byte[] lengthBuf;
    private int forwardPosition = 0;
    private int reversePosition = 0;

    public BinaryEncoder(int initialCapacity) {
        this.buf = new byte[initialCapacity];
    }

    public BinaryEncoder(int forwardInitCap, int reverseInitCap) {
        this.buf = new byte[forwardInitCap];
        this.lengthBuf = new byte[reverseInitCap];
        this.reversePosition = reverseInitCap - 1;
    }

    public BinaryEncoder(byte[] buf) {
        this.buf = buf;
    }

    public BinaryEncoder(byte[] buf, int reverseCap) {
        int forwardCap = buf.length - reverseCap;
        this.buf = new byte[forwardCap];
        this.lengthBuf = new byte[reverseCap];
        System.arraycopy(buf, 0, this.buf, 0, forwardCap);
        System.arraycopy(buf, forwardCap, this.lengthBuf, 0, reverseCap);
        this.reversePosition = reverseCap - 1;
    }

    public BinaryEncoder(byte[] forwardBuf, byte[] reverseBuf) {
        this.buf = forwardBuf;
        this.lengthBuf = reverseBuf;
        this.reversePosition = this.lengthBuf.length - 1;
    }

    public void writeBoolean(Object bool) throws IndexOutOfBoundsException, ClassCastException {
        if (bool == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            this.buf[this.forwardPosition++] = (byte)((Boolean)bool != false ? 1 : 0);
        }
    }

    public void writeShort(Object sh) throws IndexOutOfBoundsException, ClassCastException {
        if (sh == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            this.buf[this.forwardPosition++] = (byte)((Short)sh >>> 8);
            this.buf[this.forwardPosition++] = (byte)((Short)sh >>> 0);
        }
    }

    public void writeKeyShort(Object sh) throws IndexOutOfBoundsException, ClassCastException {
        if (sh == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            this.buf[this.forwardPosition++] = (byte)((Short)sh >>> 8 ^ 0x80);
            this.buf[this.forwardPosition++] = (byte)((Short)sh >>> 0);
        }
    }

    public void writeInt(Object in) throws IndexOutOfBoundsException, ClassCastException {
        if (in == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            this.buf[this.forwardPosition++] = (byte)((Integer)in >>> 24);
            this.buf[this.forwardPosition++] = (byte)((Integer)in >>> 16);
            this.buf[this.forwardPosition++] = (byte)((Integer)in >>> 8);
            this.buf[this.forwardPosition++] = (byte)((Integer)in >>> 0);
        }
    }

    public void writeKeyInt(Object in) throws IndexOutOfBoundsException, ClassCastException {
        if (in == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            this.buf[this.forwardPosition++] = (byte)((Integer)in >>> 24 ^ 0x80);
            this.buf[this.forwardPosition++] = (byte)((Integer)in >>> 16);
            this.buf[this.forwardPosition++] = (byte)((Integer)in >>> 8);
            this.buf[this.forwardPosition++] = (byte)((Integer)in >>> 0);
        }
    }

    public void writeFloat(Object fo) throws IndexOutOfBoundsException, ClassCastException {
        if (fo == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            int in = Float.floatToIntBits(((Float)fo).floatValue());
            this.buf[this.forwardPosition++] = (byte)(in >>> 24);
            this.buf[this.forwardPosition++] = (byte)(in >>> 16);
            this.buf[this.forwardPosition++] = (byte)(in >>> 8);
            this.buf[this.forwardPosition++] = (byte)in;
        }
    }

    public void writeKeyFloat(Object fo) throws IndexOutOfBoundsException, ClassCastException {
        if (fo == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            int in = Float.floatToIntBits(((Float)fo).floatValue());
            if (in >= 0) {
                this.buf[this.forwardPosition++] = (byte)(in >>> 24 ^ 0x80);
                this.buf[this.forwardPosition++] = (byte)(in >>> 16);
                this.buf[this.forwardPosition++] = (byte)(in >>> 8);
                this.buf[this.forwardPosition++] = (byte)in;
            } else {
                this.buf[this.forwardPosition++] = (byte)(~in >>> 24);
                this.buf[this.forwardPosition++] = (byte)(~in >>> 16);
                this.buf[this.forwardPosition++] = (byte)(~in >>> 8);
                this.buf[this.forwardPosition++] = (byte)(~in);
            }
        }
    }

    public void writeLong(Object ln) throws IndexOutOfBoundsException, ClassCastException {
        if (ln == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 56);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 48);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 40);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 32);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 24);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 16);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 8);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 0);
        }
    }

    public void writeKeyLong(Object ln) throws IndexOutOfBoundsException, ClassCastException {
        if (ln == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 56 ^ 0x80L);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 48);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 40);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 32);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 24);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 16);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 8);
            this.buf[this.forwardPosition++] = (byte)((Long)ln >>> 0);
        }
    }

    public void writeDouble(Object dl) throws IndexOutOfBoundsException, ClassCastException {
        if (dl == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            long ln = Double.doubleToLongBits((Double)dl);
            this.buf[this.forwardPosition++] = (byte)(ln >>> 56);
            this.buf[this.forwardPosition++] = (byte)(ln >>> 48);
            this.buf[this.forwardPosition++] = (byte)(ln >>> 40);
            this.buf[this.forwardPosition++] = (byte)(ln >>> 32);
            this.buf[this.forwardPosition++] = (byte)(ln >>> 24);
            this.buf[this.forwardPosition++] = (byte)(ln >>> 16);
            this.buf[this.forwardPosition++] = (byte)(ln >>> 8);
            this.buf[this.forwardPosition++] = (byte)ln;
        }
    }

    public void writeKeyDouble(Object dl) throws IndexOutOfBoundsException, ClassCastException {
        if (dl == null) {
            this.writeNull();
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
            this.buf[this.forwardPosition++] = 0;
        } else {
            this.writeNotNull();
            long ln = Double.doubleToLongBits((Double)dl);
            if (ln >= 0L) {
                this.buf[this.forwardPosition++] = (byte)(ln >>> 56 ^ 0x80L);
                this.buf[this.forwardPosition++] = (byte)(ln >>> 48);
                this.buf[this.forwardPosition++] = (byte)(ln >>> 40);
                this.buf[this.forwardPosition++] = (byte)(ln >>> 32);
                this.buf[this.forwardPosition++] = (byte)(ln >>> 24);
                this.buf[this.forwardPosition++] = (byte)(ln >>> 16);
                this.buf[this.forwardPosition++] = (byte)(ln >>> 8);
                this.buf[this.forwardPosition++] = (byte)ln;
            } else {
                this.buf[this.forwardPosition++] = (byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 56);
                this.buf[this.forwardPosition++] = (byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 48);
                this.buf[this.forwardPosition++] = (byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 40);
                this.buf[this.forwardPosition++] = (byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 32);
                this.buf[this.forwardPosition++] = (byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 24);
                this.buf[this.forwardPosition++] = (byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 16);
                this.buf[this.forwardPosition++] = (byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 8);
                this.buf[this.forwardPosition++] = (byte)(ln ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public void writeBytes(Object bytes) throws IndexOutOfBoundsException, ClassCastException {
        if (bytes == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else if (((byte[])bytes).length == 0) {
            this.ensureRemainder(5);
            this.writeNotNull();
            this.writeLength(0);
        } else {
            this.internWriteBytes((byte[])bytes);
        }
    }

    public void updateBytes(Object bytes) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipBytes();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeBytes(bytes);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipBytes() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(this.readLength());
        }
    }

    public void writeKeyBytes(Object bytes) throws IndexOutOfBoundsException, ClassCastException {
        if (bytes == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else if (((byte[])bytes).length == 0) {
            this.ensureRemainder(1);
            this.writeNotNull();
            this.writeKeyLength(0);
        } else {
            this.internWriteKeyBytes((byte[])bytes);
        }
    }

    public void updateKeyBytes(Object bytes) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipKeyBytes();
        this.reversePosition += 4;
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeKeyBytes(bytes);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipKeyBytes() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(this.readKeyLength());
        }
    }

    public void writeString(Object string) throws IndexOutOfBoundsException, ClassCastException {
        if (string == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else if (((String)string).length() == 0) {
            this.ensureRemainder(5);
            this.writeNotNull();
            this.writeLength(0);
        } else {
            byte[] value = ((String)string).getBytes(StandardCharsets.UTF_8);
            this.internWriteBytes(value);
        }
    }

    public void updateString(Object string) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipString();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeString(string);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipString() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(this.readLength());
        }
    }

    public void writeKeyString(Object string) throws IndexOutOfBoundsException, ClassCastException {
        if (string == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else if (((String)string).length() == 0) {
            this.ensureRemainder(1);
            this.writeNotNull();
            this.writeKeyLength(0);
        } else {
            byte[] value = ((String)string).getBytes(StandardCharsets.UTF_8);
            this.internWriteKeyBytes(value);
        }
    }

    public void updateKeyString(Object string) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipKeyString();
        this.reversePosition += 4;
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeKeyString(string);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipKeyString() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(this.readKeyLength());
        }
    }

    public void writeBooleanList(Object booleanList) throws IndexOutOfBoundsException, ClassCastException {
        if (booleanList == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else {
            List list = (List)booleanList;
            this.ensureRemainder(5 + 2 * list.size());
            this.writeNotNull();
            this.writeLength(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.writeBoolean(list.get(i));
            }
        }
    }

    public void updateBooleanList(Object booleanList) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipBooleanList();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeBooleanList(booleanList);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipBooleanList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(2 * this.readLength());
        }
    }

    public void writeShortList(Object shortList) throws IndexOutOfBoundsException, ClassCastException {
        if (shortList == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else {
            List list = (List)shortList;
            this.ensureRemainder(5 + 3 * list.size());
            this.writeNotNull();
            this.writeLength(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.writeShort(list.get(i));
            }
        }
    }

    public void updateShortList(Object shortList) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipShortList();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeShortList(shortList);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipShortList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(3 * this.readLength());
        }
    }

    public void writeIntegerList(Object integerList) throws IndexOutOfBoundsException, ClassCastException {
        if (integerList == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else {
            List list = (List)integerList;
            this.ensureRemainder(5 + 5 * list.size());
            this.writeNotNull();
            this.writeLength(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.writeInt(list.get(i));
            }
        }
    }

    public void updateIntegerList(Object integerList) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipIntegerList();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeIntegerList(integerList);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipIntegerList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(5 * this.readLength());
        }
    }

    public void writeFloatList(Object floatList) throws IndexOutOfBoundsException, ClassCastException {
        if (floatList == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else {
            List list = (List)floatList;
            this.ensureRemainder(5 + 5 * list.size());
            this.writeNotNull();
            this.writeLength(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.writeFloat(list.get(i));
            }
        }
    }

    public void updateFloatList(Object floatList) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipFloatList();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeFloatList(floatList);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipFloatList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(5 * this.readLength());
        }
    }

    public void writeLongList(Object longList) throws IndexOutOfBoundsException, ClassCastException {
        if (longList == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else {
            List list = (List)longList;
            this.ensureRemainder(5 + 9 * list.size());
            this.writeNotNull();
            this.writeLength(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.writeLong(list.get(i));
            }
        }
    }

    public void updateLongList(Object longList) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipLongList();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeLongList(longList);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipLongList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(9 * this.readLength());
        }
    }

    public void writeDoubleList(Object doubleList) throws IndexOutOfBoundsException, ClassCastException {
        if (doubleList == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else {
            List list = (List)doubleList;
            this.ensureRemainder(5 + 9 * list.size());
            this.writeNotNull();
            this.writeLength(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.writeDouble(list.get(i));
            }
        }
    }

    public void updateDoubleList(Object doubleList) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipDoubleList();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeDoubleList(doubleList);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipDoubleList() throws IndexOutOfBoundsException {
        if (!this.readIsNull()) {
            this.skip(9 * this.readLength());
        }
    }

    public void writeBytesList(Object bytesList) throws IndexOutOfBoundsException, ClassCastException {
        if (bytesList == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else {
            List list = (List)bytesList;
            this.ensureRemainder(5);
            this.writeNotNull();
            this.writeLength(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.writeBytes(list.get(i));
            }
        }
    }

    public void updateBytesList(Object bytesList) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipBytesList();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeBytesList(bytesList);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipBytesList() throws IndexOutOfBoundsException {
        int size;
        if (!this.readIsNull() && (size = this.readLength()) > 0) {
            for (int i = 0; i < size; ++i) {
                this.skipBytes();
            }
        }
    }

    public void writeStringList(Object stringList) throws IndexOutOfBoundsException, ClassCastException {
        if (stringList == null) {
            this.ensureRemainder(1);
            this.writeNull();
        } else {
            List list = (List)stringList;
            this.ensureRemainder(5);
            this.writeNotNull();
            this.writeLength(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.writeString(list.get(i));
            }
        }
    }

    public void updateStringList(Object stringList) throws IndexOutOfBoundsException, ClassCastException {
        int startMark = this.forwardPosition;
        this.skipStringList();
        int remainBytesLength = this.buf.length - this.forwardPosition;
        byte[] remainBytes = null;
        if (remainBytesLength > 0) {
            remainBytes = Arrays.copyOfRange(this.buf, this.forwardPosition, this.buf.length);
        }
        this.forwardPosition = startMark;
        this.writeStringList(stringList);
        if (remainBytes != null) {
            this.ensureRemainder(remainBytesLength);
            System.arraycopy(remainBytes, 0, this.buf, this.forwardPosition, remainBytesLength);
        }
    }

    public void skipStringList() throws IndexOutOfBoundsException {
        int size;
        if (!this.readIsNull() && (size = this.readLength()) > 0) {
            for (int i = 0; i < size; ++i) {
                this.skipString();
            }
        }
    }

    private void writeNull() throws IndexOutOfBoundsException {
        this.buf[this.forwardPosition++] = 0;
    }

    private void writeNotNull() throws IndexOutOfBoundsException {
        this.buf[this.forwardPosition++] = 1;
    }

    private void writeLength(int length) throws IndexOutOfBoundsException {
        this.buf[this.forwardPosition++] = (byte)(length >> 24);
        this.buf[this.forwardPosition++] = (byte)(length >> 16);
        this.buf[this.forwardPosition++] = (byte)(length >> 8);
        this.buf[this.forwardPosition++] = (byte)length;
    }

    private void writeKeyLength(int length) throws IndexOutOfBoundsException {
        this.lengthBuf[this.reversePosition--] = (byte)(length >>> 24);
        this.lengthBuf[this.reversePosition--] = (byte)(length >>> 16);
        this.lengthBuf[this.reversePosition--] = (byte)(length >>> 8);
        this.lengthBuf[this.reversePosition--] = (byte)length;
    }

    private void internWriteBytes(byte[] value) throws IndexOutOfBoundsException, ClassCastException {
        this.ensureRemainder(5 + value.length);
        this.writeNotNull();
        this.writeLength(value.length);
        System.arraycopy(value, 0, this.buf, this.forwardPosition, value.length);
        this.forwardPosition += value.length;
    }

    private void internWriteKeyBytes(byte[] value) throws IndexOutOfBoundsException, ClassCastException {
        int groupNum = value.length / 8;
        int size = groupNum * 9;
        int reminderSize = value.length % 8;
        if (reminderSize > 0) {
            size += 9;
        }
        this.ensureRemainder(1 + size);
        this.writeNotNull();
        this.writeKeyLength(size);
        for (int i = 0; i < groupNum; ++i) {
            System.arraycopy(value, 8 * i, this.buf, this.forwardPosition, 8);
            this.forwardPosition += 8;
            this.buf[this.forwardPosition++] = -1;
        }
        if (reminderSize > 0) {
            System.arraycopy(value, 8 * groupNum, this.buf, this.forwardPosition, reminderSize);
            this.forwardPosition += reminderSize;
            int remindZero = 8 - reminderSize;
            for (int i = 0; i < remindZero; ++i) {
                this.buf[this.forwardPosition++] = 0;
            }
            this.buf[this.forwardPosition++] = (byte)(247 + reminderSize);
        }
    }

    private boolean readIsNull() throws IndexOutOfBoundsException {
        return this.buf[this.forwardPosition++] == 0;
    }

    public Short readShort() throws IndexOutOfBoundsException, ClassCastException {
        if (this.readIsNull()) {
            this.forwardPosition += 2;
            return null;
        }
        return (short)((this.buf[this.forwardPosition++] & 0xFF) << 8 | this.buf[this.forwardPosition++] & 0xFF);
    }

    private int readLength() throws IndexOutOfBoundsException {
        return (this.buf[this.forwardPosition++] & 0xFF) << 24 | (this.buf[this.forwardPosition++] & 0xFF) << 16 | (this.buf[this.forwardPosition++] & 0xFF) << 8 | this.buf[this.forwardPosition++] & 0xFF;
    }

    private int readKeyLength() throws IndexOutOfBoundsException {
        return (this.lengthBuf[this.reversePosition--] & 0xFF) << 24 | (this.lengthBuf[this.reversePosition--] & 0xFF) << 16 | (this.lengthBuf[this.reversePosition--] & 0xFF) << 8 | this.lengthBuf[this.reversePosition--] & 0xFF;
    }

    private void skipKeyLength() {
        this.reversePosition -= 4;
    }

    public void skip(int nu) {
        this.forwardPosition += nu;
    }

    private void ensureRemainder(int length) {
        if (this.buf.length - this.forwardPosition < length) {
            this.buf = Arrays.copyOf(this.buf, this.forwardPosition + length);
        }
    }

    public byte[] getByteArray() {
        if (this.lengthBuf != null && this.lengthBuf.length > 0) {
            this.ensureRemainder(this.lengthBuf.length);
            System.arraycopy(this.lengthBuf, 0, this.buf, this.forwardPosition, this.lengthBuf.length);
            this.forwardPosition += this.lengthBuf.length;
        }
        if (this.forwardPosition != this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.forwardPosition);
        }
        return this.buf;
    }

    public byte[] getByteArrayWithoutLength() {
        if (this.forwardPosition != this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.forwardPosition);
        }
        return this.buf;
    }
}

