/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.serial.io;

import io.dingodb.serial.io.BinaryDecoder;
import io.dingodb.serial.schema.DingoSchema;
import io.dingodb.serial.util.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RecordDecoder {
    private final List<DingoSchema> schemas;
    private final short schemaVersion;

    public RecordDecoder(List<DingoSchema> schemas, short schemaVersion) {
        this(schemas, schemaVersion, false);
    }

    public RecordDecoder(List<DingoSchema> schemas, short schemaVersion, boolean isKey) {
        if (!isKey) {
            Utils.sortSchema(schemas);
        }
        this.schemas = schemas;
        this.schemaVersion = schemaVersion;
    }

    public Object[] decode(byte[] record) throws IOException {
        BinaryDecoder bd = new BinaryDecoder(record);
        if (bd.readShort() == this.schemaVersion) {
            Object[] result = new Object[this.schemas.size()];
            for (DingoSchema schema : this.schemas) {
                switch (schema.getType()) {
                    case BOOLEAN: {
                        result[schema.getIndex()] = bd.readBoolean();
                        break;
                    }
                    case BOOLEANLIST: {
                        result[schema.getIndex()] = bd.readBooleanList();
                        break;
                    }
                    case SHORT: {
                        result[schema.getIndex()] = bd.readShort();
                        break;
                    }
                    case SHORTLIST: {
                        result[schema.getIndex()] = bd.readShortList();
                        break;
                    }
                    case INTEGER: {
                        result[schema.getIndex()] = bd.readInt();
                        break;
                    }
                    case INTEGERLIST: {
                        result[schema.getIndex()] = bd.readIntegerList();
                        break;
                    }
                    case FLOAT: {
                        result[schema.getIndex()] = bd.readFloat();
                        break;
                    }
                    case FLOATLIST: {
                        result[schema.getIndex()] = bd.readFloatList();
                        break;
                    }
                    case LONG: {
                        result[schema.getIndex()] = bd.readLong();
                        break;
                    }
                    case LONGLIST: {
                        result[schema.getIndex()] = bd.readLongList();
                        break;
                    }
                    case DOUBLE: {
                        result[schema.getIndex()] = bd.readDouble();
                        break;
                    }
                    case DOUBLELIST: {
                        result[schema.getIndex()] = bd.readDoubleList();
                        break;
                    }
                    case BYTES: {
                        result[schema.getIndex()] = bd.readBytes();
                        break;
                    }
                    case BYTESLIST: {
                        result[schema.getIndex()] = bd.readBytesList();
                        break;
                    }
                    case STRING: {
                        result[schema.getIndex()] = bd.readString();
                        break;
                    }
                    case STRINGLIST: {
                        result[schema.getIndex()] = bd.readStringList();
                        break;
                    }
                }
            }
            return result;
        }
        return null;
    }

    public Object[] decode(byte[] record, int[] index) throws IOException {
        BinaryDecoder bd = new BinaryDecoder(record);
        if (bd.readShort() == this.schemaVersion) {
            Object[] result = new Object[index.length];
            List indexList = Arrays.stream(index).boxed().collect(Collectors.toList());
            block30: for (DingoSchema schema : this.schemas) {
                int resultIndex = indexList.indexOf(schema.getIndex());
                if (resultIndex >= 0) {
                    switch (schema.getType()) {
                        case BOOLEAN: {
                            result[resultIndex] = bd.readBoolean();
                            continue block30;
                        }
                        case BOOLEANLIST: {
                            result[resultIndex] = bd.readBooleanList();
                            continue block30;
                        }
                        case SHORT: {
                            result[resultIndex] = bd.readShort();
                            continue block30;
                        }
                        case SHORTLIST: {
                            result[resultIndex] = bd.readShortList();
                            continue block30;
                        }
                        case INTEGER: {
                            result[resultIndex] = bd.readInt();
                            continue block30;
                        }
                        case INTEGERLIST: {
                            result[resultIndex] = bd.readIntegerList();
                            continue block30;
                        }
                        case FLOAT: {
                            result[resultIndex] = bd.readFloat();
                            continue block30;
                        }
                        case FLOATLIST: {
                            result[resultIndex] = bd.readFloatList();
                            continue block30;
                        }
                        case LONG: {
                            result[resultIndex] = bd.readLong();
                            continue block30;
                        }
                        case LONGLIST: {
                            result[resultIndex] = bd.readLongList();
                            continue block30;
                        }
                        case DOUBLE: {
                            result[resultIndex] = bd.readDouble();
                            continue block30;
                        }
                        case DOUBLELIST: {
                            result[resultIndex] = bd.readDoubleList();
                            continue block30;
                        }
                        case BYTES: {
                            result[resultIndex] = bd.readBytes();
                            continue block30;
                        }
                        case BYTESLIST: {
                            result[resultIndex] = bd.readBytesList();
                            continue block30;
                        }
                        case STRING: {
                            result[resultIndex] = bd.readString();
                            continue block30;
                        }
                        case STRINGLIST: {
                            result[resultIndex] = bd.readStringList();
                            continue block30;
                        }
                    }
                    result[resultIndex] = null;
                    continue;
                }
                switch (schema.getType()) {
                    case BOOLEANLIST: {
                        bd.skipBooleanList();
                        continue block30;
                    }
                    case SHORTLIST: {
                        bd.skipShortList();
                        continue block30;
                    }
                    case INTEGERLIST: {
                        bd.skipIntegerList();
                        continue block30;
                    }
                    case FLOATLIST: {
                        bd.skipFloatList();
                        continue block30;
                    }
                    case LONGLIST: {
                        bd.skipLongList();
                        continue block30;
                    }
                    case DOUBLELIST: {
                        bd.skipDoubleList();
                        continue block30;
                    }
                    case BYTES: {
                        bd.skipBytes();
                        continue block30;
                    }
                    case STRING: {
                        bd.skipString();
                        continue block30;
                    }
                    case BYTESLIST: {
                        bd.skipBytesList();
                        continue block30;
                    }
                    case STRINGLIST: {
                        bd.skipStringList();
                        continue block30;
                    }
                }
                bd.skip(schema.getLength());
            }
            return result;
        }
        throw new RuntimeException("Schema version Wrong!");
    }

    public Object[] decodeKey(byte[] record) throws IOException {
        BinaryDecoder bd = new BinaryDecoder(record);
        if (bd.readShort() == this.schemaVersion) {
            Object[] result = new Object[this.schemas.size()];
            for (DingoSchema schema : this.schemas) {
                switch (schema.getType()) {
                    case BOOLEAN: {
                        result[schema.getIndex()] = bd.readBoolean();
                        break;
                    }
                    case BOOLEANLIST: {
                        result[schema.getIndex()] = bd.readBooleanList();
                        break;
                    }
                    case SHORT: {
                        result[schema.getIndex()] = bd.readKeyShort();
                        break;
                    }
                    case SHORTLIST: {
                        result[schema.getIndex()] = bd.readShortList();
                        break;
                    }
                    case INTEGER: {
                        result[schema.getIndex()] = bd.readKeyInt();
                        break;
                    }
                    case INTEGERLIST: {
                        result[schema.getIndex()] = bd.readIntegerList();
                        break;
                    }
                    case FLOAT: {
                        result[schema.getIndex()] = bd.readKeyFloat();
                        break;
                    }
                    case FLOATLIST: {
                        result[schema.getIndex()] = bd.readFloatList();
                        break;
                    }
                    case LONG: {
                        result[schema.getIndex()] = bd.readKeyLong();
                        break;
                    }
                    case LONGLIST: {
                        result[schema.getIndex()] = bd.readLongList();
                        break;
                    }
                    case DOUBLE: {
                        result[schema.getIndex()] = bd.readKeyDouble();
                        break;
                    }
                    case DOUBLELIST: {
                        result[schema.getIndex()] = bd.readDoubleList();
                        break;
                    }
                    case BYTES: {
                        result[schema.getIndex()] = bd.readKeyBytes();
                        break;
                    }
                    case BYTESLIST: {
                        result[schema.getIndex()] = bd.readBytesList();
                        break;
                    }
                    case STRING: {
                        result[schema.getIndex()] = bd.readKeyString();
                        break;
                    }
                    case STRINGLIST: {
                        result[schema.getIndex()] = bd.readStringList();
                        break;
                    }
                }
            }
            return result;
        }
        return null;
    }

    public Object[] decodeKey(byte[] record, int[] index) throws IOException {
        BinaryDecoder bd = new BinaryDecoder(record);
        if (bd.readShort() == this.schemaVersion) {
            Object[] result = new Object[index.length];
            List indexList = Arrays.stream(index).boxed().collect(Collectors.toList());
            block30: for (DingoSchema schema : this.schemas) {
                int resultIndex = indexList.indexOf(schema.getIndex());
                if (resultIndex >= 0) {
                    switch (schema.getType()) {
                        case BOOLEAN: {
                            result[resultIndex] = bd.readBoolean();
                            continue block30;
                        }
                        case BOOLEANLIST: {
                            result[resultIndex] = bd.readBooleanList();
                            continue block30;
                        }
                        case SHORT: {
                            result[resultIndex] = bd.readKeyShort();
                            continue block30;
                        }
                        case SHORTLIST: {
                            result[resultIndex] = bd.readShortList();
                            continue block30;
                        }
                        case INTEGER: {
                            result[resultIndex] = bd.readKeyInt();
                            continue block30;
                        }
                        case INTEGERLIST: {
                            result[resultIndex] = bd.readIntegerList();
                            continue block30;
                        }
                        case FLOAT: {
                            result[resultIndex] = bd.readKeyFloat();
                            continue block30;
                        }
                        case FLOATLIST: {
                            result[resultIndex] = bd.readFloatList();
                            continue block30;
                        }
                        case LONG: {
                            result[resultIndex] = bd.readKeyLong();
                            continue block30;
                        }
                        case LONGLIST: {
                            result[resultIndex] = bd.readLongList();
                            continue block30;
                        }
                        case DOUBLE: {
                            result[resultIndex] = bd.readKeyDouble();
                            continue block30;
                        }
                        case DOUBLELIST: {
                            result[resultIndex] = bd.readDoubleList();
                            continue block30;
                        }
                        case BYTES: {
                            result[resultIndex] = bd.readKeyBytes();
                            continue block30;
                        }
                        case BYTESLIST: {
                            result[resultIndex] = bd.readBytesList();
                            continue block30;
                        }
                        case STRING: {
                            result[resultIndex] = bd.readKeyString();
                            continue block30;
                        }
                        case STRINGLIST: {
                            result[resultIndex] = bd.readStringList();
                            continue block30;
                        }
                    }
                    result[resultIndex] = null;
                    continue;
                }
                switch (schema.getType()) {
                    case BOOLEANLIST: {
                        bd.skipBooleanList();
                        continue block30;
                    }
                    case SHORTLIST: {
                        bd.skipShortList();
                        continue block30;
                    }
                    case INTEGERLIST: {
                        bd.skipIntegerList();
                        continue block30;
                    }
                    case FLOATLIST: {
                        bd.skipFloatList();
                        continue block30;
                    }
                    case LONGLIST: {
                        bd.skipLongList();
                        continue block30;
                    }
                    case DOUBLELIST: {
                        bd.skipDoubleList();
                        continue block30;
                    }
                    case BYTES: {
                        bd.skipKeyBytes();
                        continue block30;
                    }
                    case STRING: {
                        bd.skipKeyString();
                        continue block30;
                    }
                    case BYTESLIST: {
                        bd.skipBytesList();
                        continue block30;
                    }
                    case STRINGLIST: {
                        bd.skipStringList();
                        continue block30;
                    }
                }
                bd.skip(schema.getLength());
            }
            return result;
        }
        throw new RuntimeException("Schema version Wrong!");
    }
}

