/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.serial.io;

import io.dingodb.serial.io.BinaryEncoder;
import io.dingodb.serial.schema.DingoSchema;
import io.dingodb.serial.util.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RecordEncoder {
    private final List<DingoSchema> schemas;
    private final short schemaVersion;
    private final int approPerRecordSize;
    private final int perRecordKeySize;

    public RecordEncoder(List<DingoSchema> schemas, short schemaVersion) {
        this(schemas, schemaVersion, false);
    }

    public RecordEncoder(List<DingoSchema> schemas, short schemaVersion, boolean isKey) {
        if (!isKey) {
            Utils.sortSchema(schemas);
        }
        this.schemas = schemas;
        this.schemaVersion = schemaVersion;
        int[] approSize = Utils.getApproPerRecordSize(schemas);
        this.approPerRecordSize = approSize[0] + 3;
        this.perRecordKeySize = approSize[1];
    }

    public byte[] encode(Object[] record) throws IOException {
        BinaryEncoder be = new BinaryEncoder(new byte[this.approPerRecordSize]);
        be.writeShort(this.schemaVersion);
        for (DingoSchema schema : this.schemas) {
            switch (schema.getType()) {
                case BOOLEAN: {
                    be.writeBoolean(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case BOOLEANLIST: {
                    be.writeBooleanList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case SHORT: {
                    be.writeShort(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case SHORTLIST: {
                    be.writeShortList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case INTEGER: {
                    be.writeInt(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case INTEGERLIST: {
                    be.writeIntegerList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case FLOAT: {
                    be.writeFloat(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case FLOATLIST: {
                    be.writeFloatList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case LONG: {
                    be.writeLong(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case LONGLIST: {
                    be.writeLongList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case DOUBLE: {
                    be.writeDouble(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case DOUBLELIST: {
                    be.writeDoubleList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case BYTES: {
                    be.writeBytes(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case BYTESLIST: {
                    be.writeBytesList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case STRING: {
                    be.writeString(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case STRINGLIST: {
                    be.writeStringList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
            }
        }
        return be.getByteArray();
    }

    public byte[] encode(byte[] record, int[] index, Object[] columns) throws IOException {
        BinaryEncoder be = new BinaryEncoder(record);
        if (be.readShort() == this.schemaVersion) {
            List indexList = Arrays.stream(index).boxed().collect(Collectors.toList());
            block28: for (DingoSchema schema : this.schemas) {
                int columnIndex = indexList.indexOf(schema.getIndex());
                if (columnIndex >= 0) {
                    switch (schema.getType()) {
                        case BOOLEAN: {
                            be.writeBoolean(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case BOOLEANLIST: {
                            be.updateBooleanList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case SHORT: {
                            be.writeShort(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case SHORTLIST: {
                            be.updateShortList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case INTEGER: {
                            be.writeInt(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case INTEGERLIST: {
                            be.updateIntegerList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case FLOAT: {
                            be.writeFloat(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case FLOATLIST: {
                            be.updateFloatList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case LONG: {
                            be.writeLong(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case LONGLIST: {
                            be.updateLongList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case DOUBLE: {
                            be.writeDouble(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case DOUBLELIST: {
                            be.updateDoubleList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case STRING: {
                            be.updateString(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case STRINGLIST: {
                            be.updateStringList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case BYTES: {
                            be.updateBytes(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                        case BYTESLIST: {
                            be.updateBytesList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block28;
                        }
                    }
                    continue;
                }
                switch (schema.getType()) {
                    case BOOLEANLIST: {
                        be.skipBooleanList();
                        continue block28;
                    }
                    case SHORTLIST: {
                        be.skipShortList();
                        continue block28;
                    }
                    case INTEGERLIST: {
                        be.skipIntegerList();
                        continue block28;
                    }
                    case FLOATLIST: {
                        be.skipFloatList();
                        continue block28;
                    }
                    case LONGLIST: {
                        be.skipLongList();
                        continue block28;
                    }
                    case DOUBLELIST: {
                        be.skipDoubleList();
                        continue block28;
                    }
                    case BYTES: 
                    case STRING: {
                        be.skipString();
                        continue block28;
                    }
                    case BYTESLIST: 
                    case STRINGLIST: {
                        be.skipStringList();
                        continue block28;
                    }
                }
                be.skip(schema.getLength());
            }
            return be.getByteArray();
        }
        throw new RuntimeException("Schema version Wrong!");
    }

    public byte[] encodeKey(Object[] record) throws IOException {
        return this.internalEncodeKey(record).getByteArray();
    }

    public byte[] encodeKey(byte[] record, int[] index, Object[] columns) throws IOException {
        BinaryEncoder be = new BinaryEncoder(record, this.perRecordKeySize);
        if (be.readShort() == this.schemaVersion) {
            List indexList = Arrays.stream(index).boxed().collect(Collectors.toList());
            block30: for (DingoSchema schema : this.schemas) {
                int columnIndex = indexList.indexOf(schema.getIndex());
                if (columnIndex >= 0) {
                    switch (schema.getType()) {
                        case BOOLEAN: {
                            be.writeBoolean(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case BOOLEANLIST: {
                            be.updateBooleanList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case SHORT: {
                            be.writeKeyShort(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case SHORTLIST: {
                            be.updateShortList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case INTEGER: {
                            be.writeKeyInt(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case INTEGERLIST: {
                            be.updateIntegerList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case FLOAT: {
                            be.writeKeyFloat(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case FLOATLIST: {
                            be.updateFloatList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case LONG: {
                            be.writeKeyLong(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case LONGLIST: {
                            be.updateLongList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case DOUBLE: {
                            be.writeKeyDouble(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case DOUBLELIST: {
                            be.updateDoubleList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case BYTES: {
                            be.updateKeyBytes(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case BYTESLIST: {
                            be.updateBytesList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case STRING: {
                            be.updateKeyString(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                        case STRINGLIST: {
                            be.updateStringList(Utils.processNullColumn(schema, columns[columnIndex]));
                            continue block30;
                        }
                    }
                    continue;
                }
                switch (schema.getType()) {
                    case BOOLEANLIST: {
                        be.skipBooleanList();
                        continue block30;
                    }
                    case SHORTLIST: {
                        be.skipShortList();
                        continue block30;
                    }
                    case INTEGERLIST: {
                        be.skipIntegerList();
                        continue block30;
                    }
                    case FLOATLIST: {
                        be.skipFloatList();
                        continue block30;
                    }
                    case LONGLIST: {
                        be.skipLongList();
                        continue block30;
                    }
                    case DOUBLELIST: {
                        be.skipDoubleList();
                        continue block30;
                    }
                    case BYTES: {
                        be.skipKeyBytes();
                        continue block30;
                    }
                    case STRING: {
                        be.skipKeyString();
                        continue block30;
                    }
                    case BYTESLIST: {
                        be.skipBytesList();
                        continue block30;
                    }
                    case STRINGLIST: {
                        be.skipStringList();
                        continue block30;
                    }
                }
                be.skip(schema.getLength());
            }
            return be.getByteArray();
        }
        throw new RuntimeException("Schema version Wrong!");
    }

    public byte[] encodeKeyWithoutLength(Object[] record) throws IOException {
        return this.internalEncodeKey(record).getByteArrayWithoutLength();
    }

    private BinaryEncoder internalEncodeKey(Object[] record) throws IOException {
        BinaryEncoder be = new BinaryEncoder(new byte[this.approPerRecordSize], new byte[this.perRecordKeySize]);
        be.writeShort(this.schemaVersion);
        for (DingoSchema schema : this.schemas) {
            switch (schema.getType()) {
                case BOOLEAN: {
                    be.writeBoolean(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case BOOLEANLIST: {
                    be.writeBooleanList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case SHORT: {
                    be.writeKeyShort(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case SHORTLIST: {
                    be.writeShortList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case INTEGER: {
                    be.writeKeyInt(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case INTEGERLIST: {
                    be.writeIntegerList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case FLOAT: {
                    be.writeKeyFloat(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case FLOATLIST: {
                    be.writeFloatList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case LONG: {
                    be.writeKeyLong(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case LONGLIST: {
                    be.writeLongList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case DOUBLE: {
                    be.writeKeyDouble(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case DOUBLELIST: {
                    be.writeDoubleList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case BYTES: {
                    be.writeKeyBytes(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case BYTESLIST: {
                    be.writeBytesList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case STRING: {
                    be.writeKeyString(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
                case STRINGLIST: {
                    be.writeStringList(Utils.processNullColumn(schema, record[schema.getIndex()]));
                    break;
                }
            }
        }
        return be;
    }
}

