/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.serial.schema;

import io.dingodb.serial.schema.DingoSchema;
import io.dingodb.serial.schema.Type;

public class DoubleSchema
implements DingoSchema {
    private int index;
    private boolean notNull;
    private Double defaultValue;

    public DoubleSchema(int index) {
        this.setIndex(index);
        this.setNotNull(false);
    }

    public DoubleSchema(int index, Object defaultValue) {
        this.setIndex(index);
        this.setNotNull(true);
        this.setDefaultValue(defaultValue);
    }

    @Override
    public Type getType() {
        return Type.DOUBLE;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setLength(int length) {
        throw new UnsupportedOperationException("Double Schema data length always be 9");
    }

    @Override
    public int getLength() {
        return 9;
    }

    @Override
    public void setMaxLength(int maxLength) {
        throw new UnsupportedOperationException("Double Schema data length always be 9");
    }

    @Override
    public int getMaxLength() {
        return 9;
    }

    @Override
    public void setPrecision(int precision) {
        throw new UnsupportedOperationException("Double Schema not support Precision");
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public void setScale(int scale) {
        throw new UnsupportedOperationException("Double Schema not support Scale");
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public void setDefaultValue(Object defaultValue) throws ClassCastException {
        this.defaultValue = (Double)defaultValue;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

