/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.serial.schema;

import io.dingodb.serial.schema.DingoSchema;
import io.dingodb.serial.schema.Type;

public class StringSchema
implements DingoSchema {
    private int index;
    private int maxLength;
    private boolean notNull;
    private String defaultValue;

    public StringSchema(int index, int maxLength) {
        this.setIndex(index);
        this.setMaxLength(maxLength);
        this.setNotNull(false);
    }

    public StringSchema(int index, int maxLength, Object defaultValue) {
        this.setIndex(index);
        this.setMaxLength(maxLength);
        this.setNotNull(true);
        this.setDefaultValue(defaultValue);
    }

    @Override
    public Type getType() {
        return Type.STRING;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setLength(int length) {
        throw new UnsupportedOperationException("String Schema data length always be 0 (not sure)");
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength == 0 ? 0 : 5 + maxLength;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setPrecision(int precision) {
        throw new UnsupportedOperationException("String Schema not support Precision");
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public void setScale(int scale) {
        throw new UnsupportedOperationException("String Schema not support Scale");
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public void setDefaultValue(Object defaultValue) throws ClassCastException {
        this.defaultValue = (String)defaultValue;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

