/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.serial.util;

import io.dingodb.serial.schema.DingoSchema;
import java.util.List;

public final class Utils {
    private Utils() {
    }

    public static void sortSchema(List<DingoSchema> schemas) {
        int flag = 1;
        for (int i = 0; i < schemas.size() - flag; ++i) {
            if (!Utils.lengthNotSure(schemas.get(i))) continue;
            int target = schemas.size() - flag++;
            while (Utils.lengthNotSure(schemas.get(target))) {
                if (--target == i) {
                    return;
                }
                ++flag;
            }
            schemas.set(target, schemas.set(i, schemas.get(target)));
        }
    }

    public static boolean lengthNotSure(DingoSchema schema) {
        return schema.getLength() == 0;
    }

    public static int[] getApproPerRecordSize(List<DingoSchema> schemas) {
        int approSize = 0;
        int keySize = 0;
        for (DingoSchema schema : schemas) {
            approSize += schema.getMaxLength() == 0 ? 100 : schema.getMaxLength();
            keySize += Utils.lengthNotSure(schema) ? 4 : 0;
        }
        return new int[]{approSize, keySize};
    }

    public static Object processNullColumn(DingoSchema schema, Object column) {
        if (schema.isNotNull() && column == null) {
            return schema.getDefaultValue();
        }
        return column;
    }
}

