/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.server.client.meta.service;

import io.dingodb.common.CommonId;
import io.dingodb.common.Location;
import io.dingodb.common.config.DingoConfiguration;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.common.util.ByteArrayUtils;
import io.dingodb.meta.MetaService;
import io.dingodb.meta.Part;
import io.dingodb.net.NetService;
import io.dingodb.net.NetServiceProvider;
import io.dingodb.server.api.MetaServiceApi;
import io.dingodb.server.client.connector.impl.CoordinatorConnector;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaServiceClient
implements MetaService {
    private static final Logger log = LoggerFactory.getLogger(MetaServiceClient.class);
    public static final Location CURRENT_LOCATION = new Location(DingoConfiguration.host(), DingoConfiguration.port());
    private final NetService netService = ServiceLoader.load(NetServiceProvider.class).iterator().next().get();
    private final CoordinatorConnector connector;
    private final MetaServiceApi metaServiceApi;

    public MetaServiceClient() {
        this(CoordinatorConnector.defaultConnector());
    }

    public MetaServiceClient(CoordinatorConnector connector) {
        this.connector = connector;
        this.metaServiceApi = this.netService.apiRegistry().proxy(MetaServiceApi.class, connector);
    }

    @Override
    public String getName() {
        return "DINGO";
    }

    @Override
    public void init(@Nullable Map<String, Object> props) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Location currentLocation() {
        return CURRENT_LOCATION;
    }

    @Override
    public void createTable(String arg0, TableDefinition arg1) {
        this.metaServiceApi.createTable(arg0, arg1);
    }

    @Override
    public boolean dropTable(String arg0) {
        return this.metaServiceApi.dropTable(arg0);
    }

    @Override
    public byte[] getTableKey(String arg0) {
        return this.metaServiceApi.getTableKey(arg0);
    }

    @Override
    public CommonId getTableId(String arg0) {
        return this.metaServiceApi.getTableId(arg0);
    }

    @Override
    public byte[] getIndexId(String arg0) {
        return this.metaServiceApi.getIndexId(arg0);
    }

    @Override
    public Map<String, TableDefinition> getTableDefinitions() {
        return this.metaServiceApi.getTableDefinitions();
    }

    @Override
    public NavigableMap<ByteArrayUtils.ComparableByteArray, Part> getParts(String arg0) {
        return this.metaServiceApi.getParts(arg0);
    }

    @Override
    public List<Location> getDistributes(String arg0) {
        return this.metaServiceApi.getDistributes(arg0);
    }

    public TableDefinition getTableDefinition(CommonId arg0) {
        return this.metaServiceApi.getTableDefinition(arg0);
    }

    public int registerUDF(CommonId arg0, String arg1, String arg2) {
        return this.metaServiceApi.registerUDF(arg0, arg1, arg2);
    }

    public boolean unregisterUDF(CommonId arg0, String arg1, int arg2) {
        return this.metaServiceApi.unregisterUDF(arg0, arg1, arg2);
    }

    public String getUDF(CommonId arg0, String arg1) {
        return this.metaServiceApi.getUDF(arg0, arg1);
    }

    public String getUDF(CommonId arg0, String arg1, int arg2) {
        return this.metaServiceApi.getUDF(arg0, arg1, arg2);
    }
}

