/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.server.protocol;

import io.dingodb.common.codec.PrimitiveCodec;
import io.dingodb.common.error.DingoError;
import io.dingodb.common.error.DingoException;
import io.dingodb.common.error.FormattingError;
import io.dingodb.net.Message;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServerError implements FormattingError
{
    OK(0, "OK, no error."),
    UNSUPPORTED_CODE(11000, "Unsupported code.", "Unsupported code [%s]"),
    TABLE_EXIST(12101, "Table exist.", "Create table failed, table exist, name: [%s]"),
    TABLE_NOT_FOUND(12102, "Table not found.", "Table not found, name: [%s]"),
    CREATE_META_SUCCESS_WAIT_LEADER_FAILED(12101, "Meta info add success, but wait leader time out.", "Table [%s] meta add success, but wait all partition leader success time out."),
    CHECK_AND_WAIT_HELIX_ACTIVE(12901, "Check helix status error.", "Check helix status and wait active."),
    UNKNOWN(19000, "Unknown, please check server log.", "Unknown error, message: [%s]"),
    IO(19001, "IO error, please check log.", "IO error, message: [%s]"),
    TO_JSON_ERROR(19301, "To json error.", "To json error, happened in [%s], error message: -[%s]-");

    private static final Logger log;
    private final int code;
    private final String info;
    private final String format;
    private static Map<Integer, ServerError> valueOfCache;

    private ServerError(int code, String info) {
        this.code = code;
        this.info = info;
        this.format = info;
    }

    private ServerError(int code, String info, String format2) {
        this.code = code;
        this.info = info;
        this.format = format2;
        ServerError.addCache(code, this);
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public String toString() {
        return DingoError.toString(this);
    }

    public Message message() {
        return Message.builder().content(PrimitiveCodec.encodeZigZagInt(this.getCode())).build();
    }

    public static Message message(DingoException err) {
        return Message.builder().content(PrimitiveCodec.encodeZigZagInt(err.getCode())).build();
    }

    private static void addCache(int code, ServerError error2) {
        if (valueOfCache == null) {
            valueOfCache = new HashMap<Integer, ServerError>();
        }
        valueOfCache.put(code, error2);
    }

    public static ServerError valueOf(Integer code) {
        return valueOfCache.computeIfAbsent(code, k -> Arrays.stream(ServerError.values()).filter(c -> c.code == code).findAny().orElse(null));
    }

    public static ServerError valueOf(byte[] bytes) {
        Integer code = PrimitiveCodec.readZigZagInt(bytes);
        return valueOfCache.computeIfAbsent(code, k -> Arrays.stream(ServerError.values()).filter(c -> c.code == code).findAny().orElse(null));
    }

    public static ServerError valueOf(ByteBuffer buffer) {
        Integer code = PrimitiveCodec.readZigZagInt(buffer);
        return valueOfCache.computeIfAbsent(code, k -> Arrays.stream(ServerError.values()).filter(c -> c.code == code).findAny().orElse(null));
    }

    static {
        log = LoggerFactory.getLogger(ServerError.class);
    }
}

