/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.server.protocol.meta;

import io.dingodb.common.CommonId;
import io.dingodb.common.Location;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.server.protocol.meta.Meta;
import io.dingodb.server.protocol.meta.MetaTableDefinitionBuilder;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Executor
implements Meta {
    public static final TableDefinition DEFINITION = new MetaTableDefinitionBuilder("EXECUTOR_META").addColumns(Arrays.stream(Fields.values()).map(Enum::name).collect(Collectors.toList())).build();
    private CommonId id;
    private String comment;
    private long createTime;
    private long updateTime;
    private byte state;
    private String host;
    private int port;
    private int raftPort;
    private int processors;
    private long memory;
    private long upTime;
    private long downTime;

    public Location location() {
        return new Location(this.host, this.port, this.raftPort);
    }

    public static ExecutorBuilder builder() {
        return new ExecutorBuilder();
    }

    @Override
    public CommonId getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public long getUpdateTime() {
        return this.updateTime;
    }

    public byte getState() {
        return this.state;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getRaftPort() {
        return this.raftPort;
    }

    public int getProcessors() {
        return this.processors;
    }

    public long getMemory() {
        return this.memory;
    }

    public long getUpTime() {
        return this.upTime;
    }

    public long getDownTime() {
        return this.downTime;
    }

    @Override
    public void setId(CommonId id) {
        this.id = id;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Override
    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRaftPort(int raftPort) {
        this.raftPort = raftPort;
    }

    public void setProcessors(int processors) {
        this.processors = processors;
    }

    public void setMemory(long memory) {
        this.memory = memory;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public void setDownTime(long downTime) {
        this.downTime = downTime;
    }

    public String toString() {
        return "Executor(id=" + this.getId() + ", comment=" + this.getComment() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", state=" + this.getState() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", raftPort=" + this.getRaftPort() + ", processors=" + this.getProcessors() + ", memory=" + this.getMemory() + ", upTime=" + this.getUpTime() + ", downTime=" + this.getDownTime() + ")";
    }

    public Executor() {
    }

    public Executor(CommonId id, String comment, long createTime, long updateTime, byte state, String host, int port, int raftPort, int processors, long memory, long upTime, long downTime) {
        this.id = id;
        this.comment = comment;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.state = state;
        this.host = host;
        this.port = port;
        this.raftPort = raftPort;
        this.processors = processors;
        this.memory = memory;
        this.upTime = upTime;
        this.downTime = downTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Executor)) {
            return false;
        }
        Executor other = (Executor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreateTime() != other.getCreateTime()) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getRaftPort() != other.getRaftPort()) {
            return false;
        }
        if (this.getProcessors() != other.getProcessors()) {
            return false;
        }
        if (this.getMemory() != other.getMemory()) {
            return false;
        }
        if (this.getUpTime() != other.getUpTime()) {
            return false;
        }
        if (this.getDownTime() != other.getDownTime()) {
            return false;
        }
        CommonId this$id = this.getId();
        CommonId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Executor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTime = this.getCreateTime();
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        result = result * 59 + this.getState();
        result = result * 59 + this.getPort();
        result = result * 59 + this.getRaftPort();
        result = result * 59 + this.getProcessors();
        long $memory = this.getMemory();
        result = result * 59 + (int)($memory >>> 32 ^ $memory);
        long $upTime = this.getUpTime();
        result = result * 59 + (int)($upTime >>> 32 ^ $upTime);
        long $downTime = this.getDownTime();
        result = result * 59 + (int)($downTime >>> 32 ^ $downTime);
        CommonId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public static enum Fields {
        id,
        comment,
        createTime,
        updateTime,
        state,
        host,
        port,
        raftPort,
        processors,
        memory,
        upTime,
        downTime;

    }

    public static class ExecutorBuilder {
        private CommonId id;
        private String comment;
        private long createTime;
        private long updateTime;
        private byte state;
        private String host;
        private int port;
        private int raftPort;
        private int processors;
        private long memory;
        private long upTime;
        private long downTime;

        ExecutorBuilder() {
        }

        public ExecutorBuilder id(CommonId id) {
            this.id = id;
            return this;
        }

        public ExecutorBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ExecutorBuilder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public ExecutorBuilder updateTime(long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ExecutorBuilder state(byte state) {
            this.state = state;
            return this;
        }

        public ExecutorBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ExecutorBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ExecutorBuilder raftPort(int raftPort) {
            this.raftPort = raftPort;
            return this;
        }

        public ExecutorBuilder processors(int processors) {
            this.processors = processors;
            return this;
        }

        public ExecutorBuilder memory(long memory) {
            this.memory = memory;
            return this;
        }

        public ExecutorBuilder upTime(long upTime) {
            this.upTime = upTime;
            return this;
        }

        public ExecutorBuilder downTime(long downTime) {
            this.downTime = downTime;
            return this;
        }

        public Executor build() {
            return new Executor(this.id, this.comment, this.createTime, this.updateTime, this.state, this.host, this.port, this.raftPort, this.processors, this.memory, this.upTime, this.downTime);
        }

        public String toString() {
            return "Executor.ExecutorBuilder(id=" + this.id + ", comment=" + this.comment + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", state=" + this.state + ", host=" + this.host + ", port=" + this.port + ", raftPort=" + this.raftPort + ", processors=" + this.processors + ", memory=" + this.memory + ", upTime=" + this.upTime + ", downTime=" + this.downTime + ")";
        }
    }
}

