/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.server.protocol.meta;

import io.dingodb.common.CommonId;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.server.protocol.meta.MetaTableDefinitionBuilder;
import io.dingodb.server.protocol.meta.Stats;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ExecutorStats
implements Stats {
    public static final TableDefinition DEFINITION = new MetaTableDefinitionBuilder("EXECUTOR_STATS").addColumns(Arrays.stream(Fields.values()).map(Enum::name).collect(Collectors.toList())).build();
    private CommonId id;
    private long time;
    private long memory;
    private long diskCapacity;
    private long diskUsable;
    private long writePerSecond;
    private long readPerSecond;
    private long writeBytesPerSecond;
    private long readBytesPerSecond;

    public static ExecutorStatsBuilder builder() {
        return new ExecutorStatsBuilder();
    }

    @Override
    public CommonId getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public long getMemory() {
        return this.memory;
    }

    public long getDiskCapacity() {
        return this.diskCapacity;
    }

    public long getDiskUsable() {
        return this.diskUsable;
    }

    public long getWritePerSecond() {
        return this.writePerSecond;
    }

    public long getReadPerSecond() {
        return this.readPerSecond;
    }

    public long getWriteBytesPerSecond() {
        return this.writeBytesPerSecond;
    }

    public long getReadBytesPerSecond() {
        return this.readBytesPerSecond;
    }

    @Override
    public void setId(CommonId id) {
        this.id = id;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setMemory(long memory) {
        this.memory = memory;
    }

    public void setDiskCapacity(long diskCapacity) {
        this.diskCapacity = diskCapacity;
    }

    public void setDiskUsable(long diskUsable) {
        this.diskUsable = diskUsable;
    }

    public void setWritePerSecond(long writePerSecond) {
        this.writePerSecond = writePerSecond;
    }

    public void setReadPerSecond(long readPerSecond) {
        this.readPerSecond = readPerSecond;
    }

    public void setWriteBytesPerSecond(long writeBytesPerSecond) {
        this.writeBytesPerSecond = writeBytesPerSecond;
    }

    public void setReadBytesPerSecond(long readBytesPerSecond) {
        this.readBytesPerSecond = readBytesPerSecond;
    }

    public String toString() {
        return "ExecutorStats(id=" + this.getId() + ", time=" + this.getTime() + ", memory=" + this.getMemory() + ", diskCapacity=" + this.getDiskCapacity() + ", diskUsable=" + this.getDiskUsable() + ", writePerSecond=" + this.getWritePerSecond() + ", readPerSecond=" + this.getReadPerSecond() + ", writeBytesPerSecond=" + this.getWriteBytesPerSecond() + ", readBytesPerSecond=" + this.getReadBytesPerSecond() + ")";
    }

    public ExecutorStats() {
    }

    public ExecutorStats(CommonId id, long time, long memory, long diskCapacity, long diskUsable, long writePerSecond, long readPerSecond, long writeBytesPerSecond, long readBytesPerSecond) {
        this.id = id;
        this.time = time;
        this.memory = memory;
        this.diskCapacity = diskCapacity;
        this.diskUsable = diskUsable;
        this.writePerSecond = writePerSecond;
        this.readPerSecond = readPerSecond;
        this.writeBytesPerSecond = writeBytesPerSecond;
        this.readBytesPerSecond = readBytesPerSecond;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutorStats)) {
            return false;
        }
        ExecutorStats other = (ExecutorStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.getMemory() != other.getMemory()) {
            return false;
        }
        if (this.getDiskCapacity() != other.getDiskCapacity()) {
            return false;
        }
        if (this.getDiskUsable() != other.getDiskUsable()) {
            return false;
        }
        if (this.getWritePerSecond() != other.getWritePerSecond()) {
            return false;
        }
        if (this.getReadPerSecond() != other.getReadPerSecond()) {
            return false;
        }
        if (this.getWriteBytesPerSecond() != other.getWriteBytesPerSecond()) {
            return false;
        }
        if (this.getReadBytesPerSecond() != other.getReadBytesPerSecond()) {
            return false;
        }
        CommonId this$id = this.getId();
        CommonId other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutorStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        long $memory = this.getMemory();
        result = result * 59 + (int)($memory >>> 32 ^ $memory);
        long $diskCapacity = this.getDiskCapacity();
        result = result * 59 + (int)($diskCapacity >>> 32 ^ $diskCapacity);
        long $diskUsable = this.getDiskUsable();
        result = result * 59 + (int)($diskUsable >>> 32 ^ $diskUsable);
        long $writePerSecond = this.getWritePerSecond();
        result = result * 59 + (int)($writePerSecond >>> 32 ^ $writePerSecond);
        long $readPerSecond = this.getReadPerSecond();
        result = result * 59 + (int)($readPerSecond >>> 32 ^ $readPerSecond);
        long $writeBytesPerSecond = this.getWriteBytesPerSecond();
        result = result * 59 + (int)($writeBytesPerSecond >>> 32 ^ $writeBytesPerSecond);
        long $readBytesPerSecond = this.getReadBytesPerSecond();
        result = result * 59 + (int)($readBytesPerSecond >>> 32 ^ $readBytesPerSecond);
        CommonId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public static enum Fields {
        id,
        time,
        memory,
        diskCapacity,
        diskUsable,
        writePerSecond,
        readPerSecond,
        writeBytesPerSecond,
        readBytesPerSecond;

    }

    public static class ExecutorStatsBuilder {
        private CommonId id;
        private long time;
        private long memory;
        private long diskCapacity;
        private long diskUsable;
        private long writePerSecond;
        private long readPerSecond;
        private long writeBytesPerSecond;
        private long readBytesPerSecond;

        ExecutorStatsBuilder() {
        }

        public ExecutorStatsBuilder id(CommonId id) {
            this.id = id;
            return this;
        }

        public ExecutorStatsBuilder time(long time) {
            this.time = time;
            return this;
        }

        public ExecutorStatsBuilder memory(long memory) {
            this.memory = memory;
            return this;
        }

        public ExecutorStatsBuilder diskCapacity(long diskCapacity) {
            this.diskCapacity = diskCapacity;
            return this;
        }

        public ExecutorStatsBuilder diskUsable(long diskUsable) {
            this.diskUsable = diskUsable;
            return this;
        }

        public ExecutorStatsBuilder writePerSecond(long writePerSecond) {
            this.writePerSecond = writePerSecond;
            return this;
        }

        public ExecutorStatsBuilder readPerSecond(long readPerSecond) {
            this.readPerSecond = readPerSecond;
            return this;
        }

        public ExecutorStatsBuilder writeBytesPerSecond(long writeBytesPerSecond) {
            this.writeBytesPerSecond = writeBytesPerSecond;
            return this;
        }

        public ExecutorStatsBuilder readBytesPerSecond(long readBytesPerSecond) {
            this.readBytesPerSecond = readBytesPerSecond;
            return this;
        }

        public ExecutorStats build() {
            return new ExecutorStats(this.id, this.time, this.memory, this.diskCapacity, this.diskUsable, this.writePerSecond, this.readPerSecond, this.writeBytesPerSecond, this.readBytesPerSecond);
        }

        public String toString() {
            return "ExecutorStats.ExecutorStatsBuilder(id=" + this.id + ", time=" + this.time + ", memory=" + this.memory + ", diskCapacity=" + this.diskCapacity + ", diskUsable=" + this.diskUsable + ", writePerSecond=" + this.writePerSecond + ", readPerSecond=" + this.readPerSecond + ", writeBytesPerSecond=" + this.writeBytesPerSecond + ", readBytesPerSecond=" + this.readBytesPerSecond + ")";
        }
    }
}

