/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.server.protocol.meta;

import io.dingodb.common.CommonId;
import io.dingodb.common.Location;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.server.protocol.meta.Meta;
import io.dingodb.server.protocol.meta.MetaTableDefinitionBuilder;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Replica
implements Meta {
    public static final TableDefinition DEFINITION = new MetaTableDefinitionBuilder("TABLE_PART_REPLICA_META").addColumns(Arrays.stream(Fields.values()).map(Enum::name).collect(Collectors.toList())).build();
    private CommonId id;
    private String comment;
    private long createTime;
    private long updateTime;
    private byte state;
    private CommonId table;
    private CommonId part;
    private CommonId executor;
    private String host;
    private int port;
    private int raftPort;

    public Location location() {
        return new Location(this.host, this.port, this.raftPort);
    }

    public static ReplicaBuilder builder() {
        return new ReplicaBuilder();
    }

    @Override
    public CommonId getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public long getUpdateTime() {
        return this.updateTime;
    }

    public byte getState() {
        return this.state;
    }

    public CommonId getTable() {
        return this.table;
    }

    public CommonId getPart() {
        return this.part;
    }

    public CommonId getExecutor() {
        return this.executor;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getRaftPort() {
        return this.raftPort;
    }

    @Override
    public void setId(CommonId id) {
        this.id = id;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Override
    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public void setTable(CommonId table) {
        this.table = table;
    }

    public void setPart(CommonId part) {
        this.part = part;
    }

    public void setExecutor(CommonId executor) {
        this.executor = executor;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRaftPort(int raftPort) {
        this.raftPort = raftPort;
    }

    public String toString() {
        return "Replica(id=" + this.getId() + ", comment=" + this.getComment() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", state=" + this.getState() + ", table=" + this.getTable() + ", part=" + this.getPart() + ", executor=" + this.getExecutor() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", raftPort=" + this.getRaftPort() + ")";
    }

    public Replica() {
    }

    public Replica(CommonId id, String comment, long createTime, long updateTime, byte state, CommonId table, CommonId part, CommonId executor, String host, int port, int raftPort) {
        this.id = id;
        this.comment = comment;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.state = state;
        this.table = table;
        this.part = part;
        this.executor = executor;
        this.host = host;
        this.port = port;
        this.raftPort = raftPort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Replica)) {
            return false;
        }
        Replica other = (Replica)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreateTime() != other.getCreateTime()) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getRaftPort() != other.getRaftPort()) {
            return false;
        }
        CommonId this$id = this.getId();
        CommonId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        CommonId this$table = this.getTable();
        CommonId other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        CommonId this$part = this.getPart();
        CommonId other$part = other.getPart();
        if (this$part == null ? other$part != null : !((Object)this$part).equals(other$part)) {
            return false;
        }
        CommonId this$executor = this.getExecutor();
        CommonId other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !((Object)this$executor).equals(other$executor)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Replica;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTime = this.getCreateTime();
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        result = result * 59 + this.getState();
        result = result * 59 + this.getPort();
        result = result * 59 + this.getRaftPort();
        CommonId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        CommonId $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        CommonId $part = this.getPart();
        result = result * 59 + ($part == null ? 43 : ((Object)$part).hashCode());
        CommonId $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : ((Object)$executor).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public static enum Fields {
        id,
        comment,
        createTime,
        updateTime,
        state,
        table,
        part,
        executor,
        host,
        port,
        raftPort;

    }

    public static class ReplicaBuilder {
        private CommonId id;
        private String comment;
        private long createTime;
        private long updateTime;
        private byte state;
        private CommonId table;
        private CommonId part;
        private CommonId executor;
        private String host;
        private int port;
        private int raftPort;

        ReplicaBuilder() {
        }

        public ReplicaBuilder id(CommonId id) {
            this.id = id;
            return this;
        }

        public ReplicaBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ReplicaBuilder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public ReplicaBuilder updateTime(long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ReplicaBuilder state(byte state) {
            this.state = state;
            return this;
        }

        public ReplicaBuilder table(CommonId table) {
            this.table = table;
            return this;
        }

        public ReplicaBuilder part(CommonId part) {
            this.part = part;
            return this;
        }

        public ReplicaBuilder executor(CommonId executor) {
            this.executor = executor;
            return this;
        }

        public ReplicaBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ReplicaBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ReplicaBuilder raftPort(int raftPort) {
            this.raftPort = raftPort;
            return this;
        }

        public Replica build() {
            return new Replica(this.id, this.comment, this.createTime, this.updateTime, this.state, this.table, this.part, this.executor, this.host, this.port, this.raftPort);
        }

        public String toString() {
            return "Replica.ReplicaBuilder(id=" + this.id + ", comment=" + this.comment + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", state=" + this.state + ", table=" + this.table + ", part=" + this.part + ", executor=" + this.executor + ", host=" + this.host + ", port=" + this.port + ", raftPort=" + this.raftPort + ")";
        }
    }
}

