/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.server.protocol.meta;

import io.dingodb.common.CommonId;
import io.dingodb.common.Location;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.server.protocol.meta.MetaTableDefinitionBuilder;
import io.dingodb.server.protocol.meta.Stats;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TablePartStats
implements Stats {
    public static final TableDefinition DEFINITION = new MetaTableDefinitionBuilder("TABLE_PART_STATS").addColumns(Arrays.stream(Fields.values()).map(Enum::name).collect(Collectors.toList())).build();
    private CommonId id;
    private long time;
    private CommonId table;
    private CommonId tablePart;
    private CommonId leader;
    private long writePerSecond;
    private long readPerSecond;
    private long writeBytesPerSecond;
    private long readBytesPerSecond;
    private List<ApproximateStats> approximateStats;
    private List<Location> alive;

    public static TablePartStatsBuilder builder() {
        return new TablePartStatsBuilder();
    }

    @Override
    public CommonId getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public CommonId getTable() {
        return this.table;
    }

    public CommonId getTablePart() {
        return this.tablePart;
    }

    public CommonId getLeader() {
        return this.leader;
    }

    public long getWritePerSecond() {
        return this.writePerSecond;
    }

    public long getReadPerSecond() {
        return this.readPerSecond;
    }

    public long getWriteBytesPerSecond() {
        return this.writeBytesPerSecond;
    }

    public long getReadBytesPerSecond() {
        return this.readBytesPerSecond;
    }

    public List<ApproximateStats> getApproximateStats() {
        return this.approximateStats;
    }

    public List<Location> getAlive() {
        return this.alive;
    }

    @Override
    public void setId(CommonId id) {
        this.id = id;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setTable(CommonId table) {
        this.table = table;
    }

    public void setTablePart(CommonId tablePart) {
        this.tablePart = tablePart;
    }

    public void setLeader(CommonId leader) {
        this.leader = leader;
    }

    public void setWritePerSecond(long writePerSecond) {
        this.writePerSecond = writePerSecond;
    }

    public void setReadPerSecond(long readPerSecond) {
        this.readPerSecond = readPerSecond;
    }

    public void setWriteBytesPerSecond(long writeBytesPerSecond) {
        this.writeBytesPerSecond = writeBytesPerSecond;
    }

    public void setReadBytesPerSecond(long readBytesPerSecond) {
        this.readBytesPerSecond = readBytesPerSecond;
    }

    public void setApproximateStats(List<ApproximateStats> approximateStats) {
        this.approximateStats = approximateStats;
    }

    public void setAlive(List<Location> alive) {
        this.alive = alive;
    }

    public String toString() {
        return "TablePartStats(id=" + this.getId() + ", time=" + this.getTime() + ", table=" + this.getTable() + ", tablePart=" + this.getTablePart() + ", leader=" + this.getLeader() + ", writePerSecond=" + this.getWritePerSecond() + ", readPerSecond=" + this.getReadPerSecond() + ", writeBytesPerSecond=" + this.getWriteBytesPerSecond() + ", readBytesPerSecond=" + this.getReadBytesPerSecond() + ", approximateStats=" + this.getApproximateStats() + ", alive=" + this.getAlive() + ")";
    }

    public TablePartStats() {
    }

    public TablePartStats(CommonId id, long time, CommonId table, CommonId tablePart, CommonId leader, long writePerSecond, long readPerSecond, long writeBytesPerSecond, long readBytesPerSecond, List<ApproximateStats> approximateStats, List<Location> alive) {
        this.id = id;
        this.time = time;
        this.table = table;
        this.tablePart = tablePart;
        this.leader = leader;
        this.writePerSecond = writePerSecond;
        this.readPerSecond = readPerSecond;
        this.writeBytesPerSecond = writeBytesPerSecond;
        this.readBytesPerSecond = readBytesPerSecond;
        this.approximateStats = approximateStats;
        this.alive = alive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TablePartStats)) {
            return false;
        }
        TablePartStats other = (TablePartStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.getWritePerSecond() != other.getWritePerSecond()) {
            return false;
        }
        if (this.getReadPerSecond() != other.getReadPerSecond()) {
            return false;
        }
        if (this.getWriteBytesPerSecond() != other.getWriteBytesPerSecond()) {
            return false;
        }
        if (this.getReadBytesPerSecond() != other.getReadBytesPerSecond()) {
            return false;
        }
        CommonId this$id = this.getId();
        CommonId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        CommonId this$table = this.getTable();
        CommonId other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        CommonId this$tablePart = this.getTablePart();
        CommonId other$tablePart = other.getTablePart();
        if (this$tablePart == null ? other$tablePart != null : !((Object)this$tablePart).equals(other$tablePart)) {
            return false;
        }
        CommonId this$leader = this.getLeader();
        CommonId other$leader = other.getLeader();
        if (this$leader == null ? other$leader != null : !((Object)this$leader).equals(other$leader)) {
            return false;
        }
        List<ApproximateStats> this$approximateStats = this.getApproximateStats();
        List<ApproximateStats> other$approximateStats = other.getApproximateStats();
        if (this$approximateStats == null ? other$approximateStats != null : !((Object)this$approximateStats).equals(other$approximateStats)) {
            return false;
        }
        List<Location> this$alive = this.getAlive();
        List<Location> other$alive = other.getAlive();
        return !(this$alive == null ? other$alive != null : !((Object)this$alive).equals(other$alive));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TablePartStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        long $writePerSecond = this.getWritePerSecond();
        result = result * 59 + (int)($writePerSecond >>> 32 ^ $writePerSecond);
        long $readPerSecond = this.getReadPerSecond();
        result = result * 59 + (int)($readPerSecond >>> 32 ^ $readPerSecond);
        long $writeBytesPerSecond = this.getWriteBytesPerSecond();
        result = result * 59 + (int)($writeBytesPerSecond >>> 32 ^ $writeBytesPerSecond);
        long $readBytesPerSecond = this.getReadBytesPerSecond();
        result = result * 59 + (int)($readBytesPerSecond >>> 32 ^ $readBytesPerSecond);
        CommonId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        CommonId $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        CommonId $tablePart = this.getTablePart();
        result = result * 59 + ($tablePart == null ? 43 : ((Object)$tablePart).hashCode());
        CommonId $leader = this.getLeader();
        result = result * 59 + ($leader == null ? 43 : ((Object)$leader).hashCode());
        List<ApproximateStats> $approximateStats = this.getApproximateStats();
        result = result * 59 + ($approximateStats == null ? 43 : ((Object)$approximateStats).hashCode());
        List<Location> $alive = this.getAlive();
        result = result * 59 + ($alive == null ? 43 : ((Object)$alive).hashCode());
        return result;
    }

    public static enum Fields {
        id,
        time,
        table,
        tablePart,
        leader,
        writePerSecond,
        readPerSecond,
        writeBytesPerSecond,
        readBytesPerSecond,
        approximateStats,
        alive;

    }

    public static class TablePartStatsBuilder {
        private CommonId id;
        private long time;
        private CommonId table;
        private CommonId tablePart;
        private CommonId leader;
        private long writePerSecond;
        private long readPerSecond;
        private long writeBytesPerSecond;
        private long readBytesPerSecond;
        private List<ApproximateStats> approximateStats;
        private List<Location> alive;

        TablePartStatsBuilder() {
        }

        public TablePartStatsBuilder id(CommonId id) {
            this.id = id;
            return this;
        }

        public TablePartStatsBuilder time(long time) {
            this.time = time;
            return this;
        }

        public TablePartStatsBuilder table(CommonId table) {
            this.table = table;
            return this;
        }

        public TablePartStatsBuilder tablePart(CommonId tablePart) {
            this.tablePart = tablePart;
            return this;
        }

        public TablePartStatsBuilder leader(CommonId leader) {
            this.leader = leader;
            return this;
        }

        public TablePartStatsBuilder writePerSecond(long writePerSecond) {
            this.writePerSecond = writePerSecond;
            return this;
        }

        public TablePartStatsBuilder readPerSecond(long readPerSecond) {
            this.readPerSecond = readPerSecond;
            return this;
        }

        public TablePartStatsBuilder writeBytesPerSecond(long writeBytesPerSecond) {
            this.writeBytesPerSecond = writeBytesPerSecond;
            return this;
        }

        public TablePartStatsBuilder readBytesPerSecond(long readBytesPerSecond) {
            this.readBytesPerSecond = readBytesPerSecond;
            return this;
        }

        public TablePartStatsBuilder approximateStats(List<ApproximateStats> approximateStats) {
            this.approximateStats = approximateStats;
            return this;
        }

        public TablePartStatsBuilder alive(List<Location> alive) {
            this.alive = alive;
            return this;
        }

        public TablePartStats build() {
            return new TablePartStats(this.id, this.time, this.table, this.tablePart, this.leader, this.writePerSecond, this.readPerSecond, this.writeBytesPerSecond, this.readBytesPerSecond, this.approximateStats, this.alive);
        }

        public String toString() {
            return "TablePartStats.TablePartStatsBuilder(id=" + this.id + ", time=" + this.time + ", table=" + this.table + ", tablePart=" + this.tablePart + ", leader=" + this.leader + ", writePerSecond=" + this.writePerSecond + ", readPerSecond=" + this.readPerSecond + ", writeBytesPerSecond=" + this.writeBytesPerSecond + ", readBytesPerSecond=" + this.readBytesPerSecond + ", approximateStats=" + this.approximateStats + ", alive=" + this.alive + ")";
        }
    }

    public static class ApproximateStats {
        byte[] startKey;
        byte[] endKey;
        Long count;
        Long size;

        public byte[] getStartKey() {
            return this.startKey;
        }

        public byte[] getEndKey() {
            return this.endKey;
        }

        public Long getCount() {
            return this.count;
        }

        public Long getSize() {
            return this.size;
        }

        public void setStartKey(byte[] startKey) {
            this.startKey = startKey;
        }

        public void setEndKey(byte[] endKey) {
            this.endKey = endKey;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public void setSize(Long size) {
            this.size = size;
        }

        public String toString() {
            return "TablePartStats.ApproximateStats(startKey=" + Arrays.toString(this.getStartKey()) + ", endKey=" + Arrays.toString(this.getEndKey()) + ", count=" + this.getCount() + ", size=" + this.getSize() + ")";
        }

        public ApproximateStats(byte[] startKey, byte[] endKey, Long count, Long size) {
            this.startKey = startKey;
            this.endKey = endKey;
            this.count = count;
            this.size = size;
        }
    }
}

