/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteArrayInput;
import io.protostuff.CodedInput;
import io.protostuff.LimitedInputStream;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufException;
import io.protostuff.ProtobufOutput;
import io.protostuff.Schema;
import io.protostuff.UninitializedMessageException;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class IOUtil {
    private IOUtil() {
    }

    static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) {
        try {
            ByteArrayInput input = new ByteArrayInput(data, offset, length, decodeNestedMessageAsGroup);
            schema.mergeFrom(input, message);
            input.checkLastTagWas(0);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new RuntimeException("Truncated.", ProtobufException.truncatedMessage(ae));
        }
        catch (IOException e) {
            throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", e);
        }
    }

    static <T> void mergeFrom(InputStream in, byte[] buf, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        CodedInput input = new CodedInput(in, buf, decodeNestedMessageAsGroup);
        schema.mergeFrom(input, message);
        input.checkLastTagWas(0);
    }

    static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        CodedInput input = new CodedInput(in, decodeNestedMessageAsGroup);
        schema.mergeFrom(input, message);
        input.checkLastTagWas(0);
    }

    static <T> int mergeDelimitedFrom(InputStream in, byte[] buf, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        int len2;
        int size = in.read();
        if (size == -1) {
            throw new EOFException("mergeDelimitedFrom");
        }
        int n = len2 = size < 128 ? size : CodedInput.readRawVarint32(in, size);
        if (len2 < 0) {
            throw ProtobufException.negativeSize();
        }
        if (len2 != 0) {
            if (len2 > buf.length) {
                throw new ProtobufException("size limit exceeded. " + len2 + " > " + buf.length);
            }
            IOUtil.fillBufferFrom(in, buf, 0, len2);
            ByteArrayInput input = new ByteArrayInput(buf, 0, len2, decodeNestedMessageAsGroup);
            try {
                schema.mergeFrom(input, message);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ProtobufException.truncatedMessage(e);
            }
            input.checkLastTagWas(0);
        }
        return len2;
    }

    static <T> int mergeDelimitedFrom(InputStream in, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        int len2;
        int size = in.read();
        if (size == -1) {
            throw new EOFException("mergeDelimitedFrom");
        }
        int n = len2 = size < 128 ? size : CodedInput.readRawVarint32(in, size);
        if (len2 < 0) {
            throw ProtobufException.negativeSize();
        }
        if (len2 != 0) {
            if (len2 > 4096) {
                CodedInput input = new CodedInput(new LimitedInputStream(in, len2), decodeNestedMessageAsGroup);
                schema.mergeFrom(input, message);
                input.checkLastTagWas(0);
                return len2;
            }
            byte[] buf = new byte[len2];
            IOUtil.fillBufferFrom(in, buf, 0, len2);
            ByteArrayInput input = new ByteArrayInput(buf, 0, len2, decodeNestedMessageAsGroup);
            try {
                schema.mergeFrom(input, message);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ProtobufException.truncatedMessage(e);
            }
            input.checkLastTagWas(0);
        }
        return len2;
    }

    static <T> int mergeDelimitedFrom(DataInput in, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        int len2;
        int size = in.readByte();
        int n = len2 = 0 == (size & 0x80) ? size : CodedInput.readRawVarint32(in, (byte)size);
        if (len2 < 0) {
            throw ProtobufException.negativeSize();
        }
        if (len2 != 0) {
            if (len2 > 4096 && in instanceof InputStream) {
                CodedInput input = new CodedInput(new LimitedInputStream((InputStream)((Object)in), len2), decodeNestedMessageAsGroup);
                schema.mergeFrom(input, message);
                input.checkLastTagWas(0);
            } else {
                byte[] buf = new byte[len2];
                in.readFully(buf, 0, len2);
                ByteArrayInput input = new ByteArrayInput(buf, 0, len2, decodeNestedMessageAsGroup);
                try {
                    schema.mergeFrom(input, message);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ProtobufException.truncatedMessage(e);
                }
                input.checkLastTagWas(0);
            }
        }
        if (!schema.isInitialized(message)) {
            throw new UninitializedMessageException(message, schema);
        }
        return len2;
    }

    static void fillBufferFrom(InputStream in, byte[] buf, int offset, int len2) throws IOException {
        int read = 0;
        while (len2 > 0) {
            read = in.read(buf, offset, len2);
            if (read == -1) {
                throw ProtobufException.truncatedMessage();
            }
            len2 -= read;
            offset += read;
        }
    }

    static int fillBufferWithDelimitedMessageFrom(InputStream in, boolean drainRemainingBytesIfTooLarge, LinkedBuffer lb) throws IOException {
        int size;
        byte[] buf = lb.buffer;
        int offset = lb.start;
        int len2 = buf.length - offset;
        int read = in.read(buf, offset, len2);
        if (read < 1) {
            throw new EOFException("fillBufferWithDelimitedMessageFrom");
        }
        int last = offset + read;
        if (0 != ((size = buf[offset++]) & 0x80)) {
            size &= 0x7F;
            int shift = 7;
            while (true) {
                block16: {
                    if (offset == last) {
                        read = in.read(buf, last, len2 - (last - lb.start));
                        if (read < 1) {
                            throw new EOFException("fillBufferWithDelimitedMessageFrom");
                        }
                        last += read;
                    }
                    byte b = buf[offset++];
                    size |= (b & 0x7F) << shift;
                    if (0 == (b & 0x80)) break;
                    if (shift == 28) {
                        int i = 0;
                        do {
                            if (offset == last) {
                                read = in.read(buf, last, len2 - (last - lb.start));
                                if (read < 1) {
                                    throw new EOFException("fillBufferWithDelimitedMessageFrom");
                                }
                                last += read;
                            }
                            if (buf[offset++] >= 0) break block16;
                        } while (5 != ++i);
                        throw ProtobufException.malformedVarint();
                    }
                }
                shift += 7;
            }
        }
        if (size == 0) {
            if (offset != last) {
                throw ProtobufException.misreportedSize();
            }
            return size;
        }
        if (size < 0) {
            throw ProtobufException.negativeSize();
        }
        int partial = last - offset;
        if (partial < size) {
            int delimSize = offset - lb.start;
            if (size + delimSize > len2) {
                if (!drainRemainingBytesIfTooLarge) {
                    return size;
                }
                for (int remaining = size - partial; remaining > 0; remaining -= read) {
                    read = in.read(buf, lb.start, Math.min(remaining, len2));
                    if (read >= 1) continue;
                    throw new EOFException("fillBufferWithDelimitedMessageFrom");
                }
                return size;
            }
            IOUtil.fillBufferFrom(in, buf, last, size - partial);
        }
        lb.offset = offset;
        return size;
    }

    static int putVarInt32AndGetOffset(int value, byte[] buffer, int variableOffset) {
        switch (ProtobufOutput.computeRawVarint32Size(value)) {
            case 1: {
                buffer[variableOffset + 4] = (byte)value;
                return variableOffset + 4;
            }
            case 2: {
                buffer[variableOffset + 3] = (byte)(value & 0x7F | 0x80);
                buffer[variableOffset + 4] = (byte)(value >>> 7);
                return variableOffset + 3;
            }
            case 3: {
                buffer[variableOffset + 2] = (byte)(value & 0x7F | 0x80);
                buffer[variableOffset + 3] = (byte)(value >>> 7 & 0x7F | 0x80);
                buffer[variableOffset + 4] = (byte)(value >>> 14);
                return variableOffset + 2;
            }
            case 4: {
                buffer[variableOffset + 1] = (byte)(value & 0x7F | 0x80);
                buffer[variableOffset + 2] = (byte)(value >>> 7 & 0x7F | 0x80);
                buffer[variableOffset + 3] = (byte)(value >>> 14 & 0x7F | 0x80);
                buffer[variableOffset + 4] = (byte)(value >>> 21);
                return variableOffset + 1;
            }
        }
        buffer[variableOffset] = (byte)(value & 0x7F | 0x80);
        buffer[variableOffset + 1] = (byte)(value >>> 7 & 0x7F | 0x80);
        buffer[variableOffset + 2] = (byte)(value >>> 14 & 0x7F | 0x80);
        buffer[variableOffset + 3] = (byte)(value >>> 21 & 0x7F | 0x80);
        buffer[variableOffset + 4] = (byte)(value >>> 28);
        return variableOffset;
    }
}

