/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class LimitedInputStream
extends FilterInputStream {
    private int limit;

    public LimitedInputStream(InputStream in) {
        super(in);
    }

    public LimitedInputStream(InputStream in, int limit) {
        super(in);
        this.limit = limit;
    }

    LimitedInputStream limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), this.limit);
    }

    @Override
    public int read() throws IOException {
        if (this.limit <= 0) {
            return -1;
        }
        int result = super.read();
        if (result >= 0) {
            --this.limit;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len2) throws IOException {
        if (this.limit <= 0) {
            return -1;
        }
        int result = super.read(b, off, len2 = Math.min(len2, this.limit));
        if (result >= 0) {
            this.limit -= result;
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = super.skip(Math.min(n, (long)this.limit));
        if (result >= 0L) {
            this.limit = (int)((long)this.limit - result);
        }
        return result;
    }
}

