/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.StringSerializer;

public final class NumberParser {
    private NumberParser() {
    }

    public static int parseInt(byte[] buffer, int start, int length, int radix) throws NumberFormatException {
        if (length == 0) {
            throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
        }
        if (buffer[start] == 45) {
            if (length == 1) {
                throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
            }
            return NumberParser.parseInt(buffer, start + 1, length - 1, radix, false);
        }
        return NumberParser.parseInt(buffer, start, length, radix, true);
    }

    static int parseInt(byte[] buffer, int start, int length, int radix, boolean positive) throws NumberFormatException {
        int max2 = Integer.MIN_VALUE / radix;
        int result = 0;
        int offset = start;
        int limit = start + length;
        while (offset < limit) {
            int digit;
            if ((digit = Character.digit(buffer[offset++], radix)) == -1) {
                throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
            }
            if (max2 > result) {
                throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
            }
            int next2 = result * radix - digit;
            if (next2 > result) {
                throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
            }
            result = next2;
        }
        if (positive && (result = -result) < 0) {
            throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
        }
        return result;
    }

    public static long parseLong(byte[] buffer, int start, int length, int radix) throws NumberFormatException {
        if (length == 0) {
            throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
        }
        if (buffer[start] == 45) {
            if (length == 1) {
                throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
            }
            return NumberParser.parseLong(buffer, start + 1, length - 1, radix, false);
        }
        return NumberParser.parseLong(buffer, start, length, radix, true);
    }

    static long parseLong(byte[] buffer, int start, int length, int radix, boolean positive) throws NumberFormatException {
        long max2 = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        int offset = start;
        int limit = start + length;
        while (offset < limit) {
            int digit;
            if ((digit = Character.digit(buffer[offset++], radix)) == -1) {
                throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
            }
            if (max2 > result) {
                throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
            }
            long next2 = result * (long)radix - (long)digit;
            if (next2 > result) {
                throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
            }
            result = next2;
        }
        if (positive && (result = -result) < 0L) {
            throw new NumberFormatException(StringSerializer.STRING.deser(buffer, start, length));
        }
        return result;
    }
}

