/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.WriteSink;
import java.io.IOException;
import java.io.OutputStream;

public class WriteSession {
    public final LinkedBuffer head;
    protected LinkedBuffer tail;
    protected int size = 0;
    public final int nextBufferSize;
    public final OutputStream out;
    public final FlushHandler flushHandler;
    public final WriteSink sink;

    public WriteSession(LinkedBuffer head) {
        this(head, 512);
    }

    public WriteSession(LinkedBuffer head, int nextBufferSize) {
        this.tail = head;
        this.head = head;
        this.nextBufferSize = nextBufferSize;
        this.out = null;
        this.flushHandler = null;
        this.sink = WriteSink.BUFFERED;
    }

    public WriteSession(LinkedBuffer head, OutputStream out, FlushHandler flushHandler, int nextBufferSize) {
        this.tail = head;
        this.head = head;
        this.nextBufferSize = nextBufferSize;
        this.out = out;
        this.flushHandler = flushHandler;
        this.sink = WriteSink.STREAMED;
        assert (out != null);
    }

    public WriteSession(LinkedBuffer head, OutputStream out) {
        this(head, out, null, 512);
    }

    public void reset() {
    }

    public WriteSession clear() {
        this.tail = this.head.clear();
        this.size = 0;
        return this;
    }

    public final int getSize() {
        return this.size;
    }

    public final byte[] toByteArray() {
        LinkedBuffer node = this.head;
        int offset = 0;
        byte[] buf = new byte[this.size];
        do {
            int len2;
            if ((len2 = node.offset - node.start) <= 0) continue;
            System.arraycopy(node.buffer, node.start, buf, offset, len2);
            offset += len2;
        } while ((node = node.next) != null);
        return buf;
    }

    protected int flush(byte[] buf, int offset, int len2) throws IOException {
        if (this.flushHandler != null) {
            return this.flushHandler.flush(this, buf, offset, len2);
        }
        this.out.write(buf, offset, len2);
        return offset;
    }

    protected int flush(byte[] buf, int offset, int len2, byte[] next2, int nextoffset, int nextlen) throws IOException {
        if (this.flushHandler != null) {
            return this.flushHandler.flush(this, buf, offset, len2, next2, nextoffset, nextlen);
        }
        this.out.write(buf, offset, len2);
        this.out.write(next2, nextoffset, nextlen);
        return offset;
    }

    protected int flush(LinkedBuffer lb, byte[] buf, int offset, int len2) throws IOException {
        if (this.flushHandler != null) {
            return this.flushHandler.flush(this, lb, buf, offset, len2);
        }
        this.out.write(buf, offset, len2);
        return lb.start;
    }

    public static interface FlushHandler {
        public int flush(WriteSession var1, byte[] var2, int var3, int var4) throws IOException;

        public int flush(WriteSession var1, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7) throws IOException;

        public int flush(WriteSession var1, LinkedBuffer var2, byte[] var3, int var4, int var5) throws IOException;
    }
}

