/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.CollectionSchema;
import io.protostuff.Input;
import io.protostuff.MapSchema;
import io.protostuff.Message;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffException;
import io.protostuff.Schema;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.EnumIO;
import io.protostuff.runtime.HasDelegate;
import io.protostuff.runtime.HasSchema;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeFieldFactory;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DefaultIdStrategy
extends IdStrategy {
    final ConcurrentHashMap<String, HasSchema<?>> pojoMapping = new ConcurrentHashMap();
    final ConcurrentHashMap<String, EnumIO<?>> enumMapping = new ConcurrentHashMap();
    final ConcurrentHashMap<String, CollectionSchema.MessageFactory> collectionMapping = new ConcurrentHashMap();
    final ConcurrentHashMap<String, MapSchema.MessageFactory> mapMapping = new ConcurrentHashMap();
    final ConcurrentHashMap<String, HasDelegate<?>> delegateMapping = new ConcurrentHashMap();

    public DefaultIdStrategy() {
        super(DEFAULT_FLAGS, null, 0);
    }

    public DefaultIdStrategy(IdStrategy primaryGroup, int groupId) {
        super(DEFAULT_FLAGS, primaryGroup, groupId);
    }

    public DefaultIdStrategy(int flags) {
        super(flags, null, 0);
    }

    public DefaultIdStrategy(int flags, IdStrategy primaryGroup, int groupId) {
        super(flags, primaryGroup, groupId);
    }

    public <T> boolean registerPojo(Class<T> typeClass, Schema<T> schema) {
        assert (typeClass != null && schema != null);
        HasSchema last = this.pojoMapping.putIfAbsent(typeClass.getName(), new Registered<T>(schema, this));
        return last == null || last instanceof Registered && ((Registered)last).schema == schema;
    }

    public <T> boolean registerPojo(Class<T> typeClass) {
        assert (typeClass != null);
        HasSchema last = this.pojoMapping.putIfAbsent(typeClass.getName(), new LazyRegister<T>(typeClass, this));
        return last == null || last instanceof LazyRegister;
    }

    public <T extends Enum<T>> boolean registerEnum(Class<T> enumClass) {
        return null == this.enumMapping.putIfAbsent(enumClass.getName(), EnumIO.newEnumIO(enumClass, this));
    }

    public <T> boolean registerDelegate(Delegate<T> delegate) {
        return this.registerDelegate(delegate.typeClass().getName(), delegate);
    }

    public <T> boolean registerDelegate(String className, Delegate<T> delegate) {
        return null == this.delegateMapping.putIfAbsent(className, new HasDelegate<T>(delegate, this));
    }

    public boolean registerCollection(CollectionSchema.MessageFactory factory) {
        return null == this.collectionMapping.putIfAbsent(factory.typeClass().getName(), factory);
    }

    public boolean registerMap(MapSchema.MessageFactory factory) {
        return null == this.mapMapping.putIfAbsent(factory.typeClass().getName(), factory);
    }

    public <T> boolean map(Class<? super T> baseClass, Class<T> typeClass) {
        assert (baseClass != null && typeClass != null);
        if (typeClass.isInterface() || Modifier.isAbstract(typeClass.getModifiers())) {
            throw new IllegalArgumentException(typeClass + " cannot be an interface/abstract class.");
        }
        HasSchema last = this.pojoMapping.putIfAbsent(baseClass.getName(), new Mapped<T>(baseClass, typeClass, this));
        return last == null || last instanceof Mapped && ((Mapped)last).typeClass == typeClass;
    }

    @Override
    public boolean isDelegateRegistered(Class<?> typeClass) {
        return this.delegateMapping.containsKey(typeClass.getName());
    }

    @Override
    public <T> HasDelegate<T> getDelegateWrapper(Class<? super T> typeClass) {
        return this.delegateMapping.get(typeClass.getName());
    }

    @Override
    public <T> Delegate<T> getDelegate(Class<? super T> typeClass) {
        HasDelegate<?> last = this.delegateMapping.get(typeClass.getName());
        return last == null ? null : last.delegate;
    }

    @Override
    public boolean isRegistered(Class<?> typeClass) {
        HasSchema<?> last = this.pojoMapping.get(typeClass.getName());
        return last != null && !(last instanceof Lazy);
    }

    private <T> HasSchema<T> getSchemaWrapper(String className, boolean load2) {
        HasSchema<?> hs = this.pojoMapping.get(className);
        if (hs == null) {
            if (!load2) {
                return null;
            }
            Class typeClass = RuntimeEnv.loadClass(className);
            hs = new Lazy(typeClass, this);
            HasSchema<?> last = this.pojoMapping.putIfAbsent(typeClass.getName(), hs);
            if (last != null) {
                hs = last;
            }
        }
        return hs;
    }

    @Override
    public <T> HasSchema<T> getSchemaWrapper(Class<T> typeClass, boolean create2) {
        HasSchema<?> hs = this.pojoMapping.get(typeClass.getName());
        if (hs == null && create2) {
            hs = new Lazy(typeClass, this);
            HasSchema<?> last = this.pojoMapping.putIfAbsent(typeClass.getName(), hs);
            if (last != null) {
                hs = last;
            }
        }
        return hs;
    }

    private EnumIO<? extends Enum<?>> getEnumIO(String className, boolean load2) {
        EnumIO<Object> eio = this.enumMapping.get(className);
        if (eio == null) {
            if (!load2) {
                return null;
            }
            Class enumClass = RuntimeEnv.loadClass(className);
            eio = EnumIO.newEnumIO(enumClass, this);
            EnumIO<?> existing = this.enumMapping.putIfAbsent(enumClass.getName(), eio);
            if (existing != null) {
                eio = existing;
            }
        }
        return eio;
    }

    @Override
    protected EnumIO<? extends Enum<?>> getEnumIO(Class<?> enumClass) {
        EnumIO<Object> eio = this.enumMapping.get(enumClass.getName());
        if (eio == null) {
            eio = EnumIO.newEnumIO(enumClass, this);
            EnumIO<?> existing = this.enumMapping.putIfAbsent(enumClass.getName(), eio);
            if (existing != null) {
                eio = existing;
            }
        }
        return eio;
    }

    @Override
    protected CollectionSchema.MessageFactory getCollectionFactory(Class<?> clazz) {
        String className = clazz.getName();
        CollectionSchema.MessageFactory factory = this.collectionMapping.get(className);
        if (factory == null) {
            if (className.startsWith("java.util") && CollectionSchema.MessageFactories.accept(clazz.getSimpleName())) {
                factory = CollectionSchema.MessageFactories.valueOf(clazz.getSimpleName());
            } else {
                factory = new RuntimeCollectionFactory(clazz);
                CollectionSchema.MessageFactory f = this.collectionMapping.putIfAbsent(className, factory);
                if (f != null) {
                    factory = f;
                }
            }
        }
        return factory;
    }

    @Override
    protected MapSchema.MessageFactory getMapFactory(Class<?> clazz) {
        String className = clazz.getName();
        MapSchema.MessageFactory factory = this.mapMapping.get(className);
        if (factory == null) {
            if (className.startsWith("java.util") && MapSchema.MessageFactories.accept(clazz.getSimpleName())) {
                factory = MapSchema.MessageFactories.valueOf(clazz.getSimpleName());
            } else {
                factory = new RuntimeMapFactory(clazz);
                MapSchema.MessageFactory f = this.mapMapping.putIfAbsent(className, factory);
                if (f != null) {
                    factory = f;
                }
            }
        }
        return factory;
    }

    @Override
    protected void writeCollectionIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        CollectionSchema.MessageFactory factory = this.collectionMapping.get(clazz.getName());
        if (factory == null && clazz.getName().startsWith("java.util") && CollectionSchema.MessageFactories.accept(clazz.getSimpleName())) {
            output.writeString(fieldNumber, clazz.getSimpleName(), false);
        } else {
            output.writeString(fieldNumber, clazz.getName(), false);
        }
    }

    @Override
    protected void transferCollectionId(Input input, Output output, int fieldNumber) throws IOException {
        input.transferByteRangeTo(output, true, fieldNumber, false);
    }

    @Override
    protected CollectionSchema.MessageFactory resolveCollectionFrom(Input input) throws IOException {
        String className = input.readString();
        CollectionSchema.MessageFactory factory = this.collectionMapping.get(className);
        if (factory == null) {
            if (className.indexOf(46) == -1 && CollectionSchema.MessageFactories.accept(className)) {
                factory = CollectionSchema.MessageFactories.valueOf(className);
            } else {
                factory = new RuntimeCollectionFactory(RuntimeEnv.loadClass(className));
                CollectionSchema.MessageFactory f = this.collectionMapping.putIfAbsent(className, factory);
                if (f != null) {
                    factory = f;
                }
            }
        }
        return factory;
    }

    @Override
    protected void writeMapIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        MapSchema.MessageFactory factory = this.mapMapping.get(clazz);
        if (factory == null && clazz.getName().startsWith("java.util") && MapSchema.MessageFactories.accept(clazz.getSimpleName())) {
            output.writeString(fieldNumber, clazz.getSimpleName(), false);
        } else {
            output.writeString(fieldNumber, clazz.getName(), false);
        }
    }

    @Override
    protected void transferMapId(Input input, Output output, int fieldNumber) throws IOException {
        input.transferByteRangeTo(output, true, fieldNumber, false);
    }

    @Override
    protected MapSchema.MessageFactory resolveMapFrom(Input input) throws IOException {
        String className = input.readString();
        MapSchema.MessageFactory factory = this.mapMapping.get(className);
        if (factory == null) {
            if (className.indexOf(46) == -1 && MapSchema.MessageFactories.accept(className)) {
                factory = MapSchema.MessageFactories.valueOf(className);
            } else {
                factory = new RuntimeMapFactory(RuntimeEnv.loadClass(className));
                MapSchema.MessageFactory f = this.mapMapping.putIfAbsent(className, factory);
                if (f != null) {
                    factory = f;
                }
            }
        }
        return factory;
    }

    @Override
    protected void writeEnumIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        output.writeString(fieldNumber, clazz.getName(), false);
    }

    @Override
    protected void transferEnumId(Input input, Output output, int fieldNumber) throws IOException {
        input.transferByteRangeTo(output, true, fieldNumber, false);
    }

    @Override
    protected EnumIO<?> resolveEnumFrom(Input input) throws IOException {
        return this.getEnumIO(input.readString(), true);
    }

    @Override
    protected <T> HasDelegate<T> tryWriteDelegateIdTo(Output output, int fieldNumber, Class<T> clazz) throws IOException {
        HasDelegate<?> hd = this.delegateMapping.get(clazz.getName());
        if (hd == null) {
            return null;
        }
        output.writeString(fieldNumber, clazz.getName(), false);
        return hd;
    }

    @Override
    protected <T> HasDelegate<T> transferDelegateId(Input input, Output output, int fieldNumber) throws IOException {
        String className = input.readString();
        HasDelegate<?> hd = this.delegateMapping.get(className);
        if (hd == null) {
            throw new IdStrategy.UnknownTypeException("delegate: " + className + " (Outdated registry)");
        }
        output.writeString(fieldNumber, className, false);
        return hd;
    }

    @Override
    protected <T> HasDelegate<T> resolveDelegateFrom(Input input) throws IOException {
        String className = input.readString();
        HasDelegate<?> hd = this.delegateMapping.get(className);
        if (hd == null) {
            throw new IdStrategy.UnknownTypeException("delegate: " + className + " (Outdated registry)");
        }
        return hd;
    }

    @Override
    protected <T> HasSchema<T> tryWritePojoIdTo(Output output, int fieldNumber, Class<T> clazz, boolean registered) throws IOException {
        HasSchema<T> hs = this.getSchemaWrapper(clazz, false);
        if (hs == null || registered && hs instanceof Lazy) {
            return null;
        }
        output.writeString(fieldNumber, clazz.getName(), false);
        return hs;
    }

    @Override
    protected <T> HasSchema<T> writePojoIdTo(Output output, int fieldNumber, Class<T> clazz) throws IOException {
        output.writeString(fieldNumber, clazz.getName(), false);
        return this.getSchemaWrapper(clazz, true);
    }

    @Override
    protected <T> HasSchema<T> transferPojoId(Input input, Output output, int fieldNumber) throws IOException {
        String className = input.readString();
        HasSchema<T> wrapper2 = this.getSchemaWrapper(className, 0 != (2 & this.flags));
        if (wrapper2 == null) {
            throw new ProtostuffException("polymorphic pojo not registered: " + className);
        }
        output.writeString(fieldNumber, className, false);
        return wrapper2;
    }

    @Override
    protected <T> HasSchema<T> resolvePojoFrom(Input input, int fieldNumber) throws IOException {
        String className = input.readString();
        HasSchema<T> wrapper2 = this.getSchemaWrapper(className, 0 != (2 & this.flags));
        if (wrapper2 == null) {
            throw new ProtostuffException("polymorphic pojo not registered: " + className);
        }
        return wrapper2;
    }

    @Override
    protected <T> Schema<T> writeMessageIdTo(Output output, int fieldNumber, Message<T> message) throws IOException {
        output.writeString(fieldNumber, message.getClass().getName(), false);
        return message.cachedSchema();
    }

    @Override
    protected void writeArrayIdTo(Output output, Class<?> componentType) throws IOException {
        output.writeString(15, componentType.getName(), false);
    }

    @Override
    protected void transferArrayId(Input input, Output output, int fieldNumber, boolean mapped) throws IOException {
        input.transferByteRangeTo(output, true, fieldNumber, false);
    }

    @Override
    protected Class<?> resolveArrayComponentTypeFrom(Input input, boolean mapped) throws IOException {
        return DefaultIdStrategy.resolveClass(input.readString());
    }

    static Class<?> resolveClass(String className) {
        RuntimeFieldFactory inline = RuntimeFieldFactory.getInline(className);
        if (inline == null) {
            return RuntimeEnv.loadClass(className);
        }
        if (className.indexOf(46) != -1) {
            return inline.typeClass();
        }
        switch (inline.id) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Byte.TYPE;
            }
            case 3: {
                return Character.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Long.TYPE;
            }
            case 7: {
                return Float.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
        }
        throw new RuntimeException("Should never happen.");
    }

    @Override
    protected void writeClassIdTo(Output output, Class<?> componentType, boolean array) throws IOException {
        int id = array ? 20 : 18;
        output.writeString(id, componentType.getName(), false);
    }

    @Override
    protected void transferClassId(Input input, Output output, int fieldNumber, boolean mapped, boolean array) throws IOException {
        input.transferByteRangeTo(output, true, fieldNumber, false);
    }

    @Override
    protected Class<?> resolveClassFrom(Input input, boolean mapped, boolean array) throws IOException {
        return DefaultIdStrategy.resolveClass(input.readString());
    }

    static final class Registered<T>
    extends HasSchema<T> {
        final Schema<T> schema;
        private volatile Pipe.Schema<T> pipeSchema;

        Registered(Schema<T> schema, IdStrategy strategy) {
            super(strategy);
            this.schema = schema;
        }

        @Override
        public Schema<T> getSchema() {
            return this.schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pipe.Schema<T> getPipeSchema() {
            Pipe.Schema<T> pipeSchema = this.pipeSchema;
            if (pipeSchema == null) {
                Registered registered = this;
                synchronized (registered) {
                    pipeSchema = this.pipeSchema;
                    if (pipeSchema == null) {
                        this.pipeSchema = pipeSchema = RuntimeSchema.resolvePipeSchema(this.schema, this.schema.typeClass(), true);
                    }
                }
            }
            return pipeSchema;
        }
    }

    static final class LazyRegister<T>
    extends HasSchema<T> {
        final Class<T> typeClass;
        private volatile Schema<T> schema;
        private volatile Pipe.Schema<T> pipeSchema;

        LazyRegister(Class<T> typeClass, IdStrategy strategy) {
            super(strategy);
            this.typeClass = typeClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Schema<T> getSchema() {
            Schema<T> schema = this.schema;
            if (schema == null) {
                LazyRegister lazyRegister = this;
                synchronized (lazyRegister) {
                    schema = this.schema;
                    if (schema == null) {
                        this.schema = schema = this.strategy.newSchema(this.typeClass);
                    }
                }
            }
            return schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pipe.Schema<T> getPipeSchema() {
            Pipe.Schema<T> pipeSchema = this.pipeSchema;
            if (pipeSchema == null) {
                LazyRegister lazyRegister = this;
                synchronized (lazyRegister) {
                    pipeSchema = this.pipeSchema;
                    if (pipeSchema == null) {
                        this.pipeSchema = pipeSchema = RuntimeSchema.resolvePipeSchema(this.getSchema(), this.typeClass, true);
                    }
                }
            }
            return pipeSchema;
        }
    }

    static final class Mapped<T>
    extends HasSchema<T> {
        final Class<? super T> baseClass;
        final Class<T> typeClass;
        private volatile HasSchema<T> wrapper;

        Mapped(Class<? super T> baseClass, Class<T> typeClass, IdStrategy strategy) {
            super(strategy);
            this.baseClass = baseClass;
            this.typeClass = typeClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Schema<T> getSchema() {
            HasSchema<T> wrapper2 = this.wrapper;
            if (wrapper2 == null) {
                Mapped mapped = this;
                synchronized (mapped) {
                    wrapper2 = this.wrapper;
                    if (wrapper2 == null) {
                        wrapper2 = this.strategy.getSchemaWrapper(this.typeClass, true);
                        this.wrapper = wrapper2;
                    }
                }
            }
            return wrapper2.getSchema();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pipe.Schema<T> getPipeSchema() {
            HasSchema<T> wrapper2 = this.wrapper;
            if (wrapper2 == null) {
                Mapped mapped = this;
                synchronized (mapped) {
                    wrapper2 = this.wrapper;
                    if (wrapper2 == null) {
                        wrapper2 = this.strategy.getSchemaWrapper(this.typeClass, true);
                        this.wrapper = wrapper2;
                    }
                }
            }
            return wrapper2.getPipeSchema();
        }
    }

    static final class Lazy<T>
    extends HasSchema<T> {
        final Class<T> typeClass;
        private volatile Schema<T> schema;
        private volatile Pipe.Schema<T> pipeSchema;

        Lazy(Class<T> typeClass, IdStrategy strategy) {
            super(strategy);
            this.typeClass = typeClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Schema<T> getSchema() {
            Schema<T> schema = this.schema;
            if (schema == null) {
                Lazy lazy = this;
                synchronized (lazy) {
                    schema = this.schema;
                    if (schema == null) {
                        if (Message.class.isAssignableFrom(this.typeClass)) {
                            Message m3 = (Message)IdStrategy.createMessageInstance(this.typeClass);
                            this.schema = schema = m3.cachedSchema();
                        } else {
                            this.schema = schema = this.strategy.newSchema(this.typeClass);
                        }
                    }
                }
            }
            return schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pipe.Schema<T> getPipeSchema() {
            Pipe.Schema<T> pipeSchema = this.pipeSchema;
            if (pipeSchema == null) {
                Lazy lazy = this;
                synchronized (lazy) {
                    pipeSchema = this.pipeSchema;
                    if (pipeSchema == null) {
                        this.pipeSchema = pipeSchema = RuntimeSchema.resolvePipeSchema(this.getSchema(), this.typeClass, true);
                    }
                }
            }
            return pipeSchema;
        }
    }

    static final class RuntimeMapFactory
    implements MapSchema.MessageFactory {
        final Class<?> mapClass;
        final RuntimeEnv.Instantiator<?> instantiator;

        public RuntimeMapFactory(Class<?> mapClass) {
            this.mapClass = mapClass;
            this.instantiator = RuntimeEnv.newInstantiator(mapClass);
        }

        @Override
        public <K, V> Map<K, V> newMessage() {
            return (Map)this.instantiator.newInstance();
        }

        @Override
        public Class<?> typeClass() {
            return this.mapClass;
        }
    }

    static final class RuntimeCollectionFactory
    implements CollectionSchema.MessageFactory {
        final Class<?> collectionClass;
        final RuntimeEnv.Instantiator<?> instantiator;

        public RuntimeCollectionFactory(Class<?> collectionClass) {
            this.collectionClass = collectionClass;
            this.instantiator = RuntimeEnv.newInstantiator(collectionClass);
        }

        @Override
        public <V> Collection<V> newMessage() {
            return (Collection)this.instantiator.newInstance();
        }

        @Override
        public Class<?> typeClass() {
            return this.collectionClass;
        }
    }
}

