/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;

public abstract class Conversion<T> {
    public abstract Class<T> getConvertedType();

    public abstract String getLogicalTypeName();

    public String adjustAndSetValue(String varName, String valParamName) {
        return varName + " = " + valParamName + ";";
    }

    public Schema getRecommendedSchema() {
        throw new UnsupportedOperationException("No recommended schema for " + this.getLogicalTypeName());
    }

    public T fromBoolean(Boolean value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromBoolean is not supported for " + type2.getName());
    }

    public T fromInt(Integer value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromInt is not supported for " + type2.getName());
    }

    public T fromLong(Long value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromLong is not supported for " + type2.getName());
    }

    public T fromFloat(Float value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromFloat is not supported for " + type2.getName());
    }

    public T fromDouble(Double value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromDouble is not supported for " + type2.getName());
    }

    public T fromCharSequence(CharSequence value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromCharSequence is not supported for " + type2.getName());
    }

    public T fromEnumSymbol(GenericEnumSymbol value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromEnumSymbol is not supported for " + type2.getName());
    }

    public T fromFixed(GenericFixed value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromFixed is not supported for " + type2.getName());
    }

    public T fromBytes(ByteBuffer value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromBytes is not supported for " + type2.getName());
    }

    public T fromArray(Collection<?> value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromArray is not supported for " + type2.getName());
    }

    public T fromMap(Map<?, ?> value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromMap is not supported for " + type2.getName());
    }

    public T fromRecord(IndexedRecord value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("fromRecord is not supported for " + type2.getName());
    }

    public Boolean toBoolean(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toBoolean is not supported for " + type2.getName());
    }

    public Integer toInt(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toInt is not supported for " + type2.getName());
    }

    public Long toLong(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toLong is not supported for " + type2.getName());
    }

    public Float toFloat(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toFloat is not supported for " + type2.getName());
    }

    public Double toDouble(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toDouble is not supported for " + type2.getName());
    }

    public CharSequence toCharSequence(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toCharSequence is not supported for " + type2.getName());
    }

    public GenericEnumSymbol toEnumSymbol(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toEnumSymbol is not supported for " + type2.getName());
    }

    public GenericFixed toFixed(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toFixed is not supported for " + type2.getName());
    }

    public ByteBuffer toBytes(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toBytes is not supported for " + type2.getName());
    }

    public Collection<?> toArray(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toArray is not supported for " + type2.getName());
    }

    public Map<?, ?> toMap(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toMap is not supported for " + type2.getName());
    }

    public IndexedRecord toRecord(T value, Schema schema, LogicalType type2) {
        throw new UnsupportedOperationException("toRecord is not supported for " + type2.getName());
    }
}

