/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.enumerable.ImmutableEnumerableLimitRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.immutables.value.Value;

@Value.Enclosing
public class EnumerableLimitRule
extends RelRule<Config> {
    protected EnumerableLimitRule(Config config) {
        super(config);
    }

    @Deprecated
    EnumerableLimitRule() {
        this(Config.DEFAULT);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort2 = (Sort)call.rel(0);
        if (sort2.offset == null && sort2.fetch == null) {
            return;
        }
        RelNode input = sort2.getInput();
        if (!sort2.getCollation().getFieldCollations().isEmpty()) {
            input = sort2.copy(sort2.getTraitSet(), input, sort2.getCollation(), null, null);
        }
        call.transformTo(EnumerableLimit.create(EnumerableLimitRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE)), sort2.offset, sort2.fetch));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableEnumerableLimitRule.Config.of().withOperandSupplier(b -> b.operand(Sort.class).anyInputs());

        @Override
        default public EnumerableLimitRule toRule() {
            return new EnumerableLimitRule(this);
        }
    }
}

