/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.enumerable.EnumerableMergeUnion;
import org.apache.calcite.adapter.enumerable.ImmutableEnumerableMergeUnionRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.immutables.value.Value;

@Value.Enclosing
public class EnumerableMergeUnionRule
extends RelRule<Config> {
    public EnumerableMergeUnionRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort2 = (Sort)call.rel(0);
        RelCollation collation = sort2.getCollation();
        if (collation == null || collation.getFieldCollations().isEmpty()) {
            return false;
        }
        Union union = (Union)call.rel(1);
        return union.getInputs().size() >= 2;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort2 = (Sort)call.rel(0);
        RelCollation collation = sort2.getCollation();
        Union union = (Union)call.rel(1);
        int unionInputsSize = union.getInputs().size();
        RexNode inputFetch = null;
        if (sort2.fetch != null) {
            if (sort2.offset == null) {
                inputFetch = sort2.fetch;
            } else if (sort2.fetch instanceof RexLiteral && sort2.offset instanceof RexLiteral) {
                inputFetch = call.builder().literal(RexLiteral.intValue(sort2.fetch) + RexLiteral.intValue(sort2.offset));
            }
        }
        ArrayList<RelNode> inputs = new ArrayList<RelNode>(unionInputsSize);
        for (RelNode input : union.getInputs()) {
            Sort newInput = sort2.copy(sort2.getTraitSet(), input, collation, null, inputFetch);
            inputs.add(EnumerableMergeUnionRule.convert((RelNode)newInput, newInput.getTraitSet().replace(EnumerableConvention.INSTANCE)));
        }
        AbstractRelNode result = EnumerableMergeUnion.create(sort2.getCollation(), inputs, union.all);
        if (sort2.offset != null || sort2.fetch != null) {
            result = EnumerableLimit.create(result, sort2.offset, sort2.fetch);
        }
        call.transformTo(result);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT_CONFIG = ImmutableEnumerableMergeUnionRule.Config.of().withDescription("EnumerableMergeUnionRule").withOperandSupplier(b0 -> b0.operand(LogicalSort.class).oneInput(b1 -> b1.operand(LogicalUnion.class).anyInputs()));

        @Override
        default public EnumerableMergeUnionRule toRule() {
            return new EnumerableMergeUnionRule(this);
        }
    }
}

