/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RepeatUnion;
import org.apache.calcite.schema.TransientTable;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableRepeatUnion
extends RepeatUnion
implements EnumerableRel {
    EnumerableRepeatUnion(RelOptCluster cluster, RelTraitSet traitSet, RelNode seed, RelNode iterative, boolean all, int iterationLimit, @Nullable RelOptTable transientTable) {
        super(cluster, traitSet, seed, iterative, all, iterationLimit, transientTable);
    }

    @Override
    public EnumerableRepeatUnion copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return new EnumerableRepeatUnion(this.getCluster(), traitSet, inputs.get(0), inputs.get(1), this.all, this.iterationLimit, this.transientTable);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        RelNode seed = this.getSeedRel();
        RelNode iteration = this.getIterativeRel();
        Expression cleanUpFunctionExp = Expressions.constant(null);
        if (this.transientTable != null) {
            Expression tableExp = implementor.stash(Objects.requireNonNull(this.transientTable.unwrap(TransientTable.class)), TransientTable.class);
            String tableName = this.transientTable.getQualifiedName().get(this.transientTable.getQualifiedName().size() - 1);
            ConstantExpression tableNameExp = Expressions.constant(tableName, String.class);
            builder.append(Expressions.call((Expression)Expressions.call((Expression)implementor.getRootExpression(), BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, new Expression[0]), BuiltInMethod.SCHEMA_PLUS_ADD_TABLE.method, tableNameExp, tableExp));
            cleanUpFunctionExp = Expressions.lambda(Function0.class, (Expression)Expressions.call((Expression)Expressions.call((Expression)implementor.getRootExpression(), BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, new Expression[0]), BuiltInMethod.SCHEMA_PLUS_REMOVE_TABLE.method, tableNameExp), new ParameterExpression[0]);
        }
        EnumerableRel.Result seedResult = implementor.visitChild(this, 0, (EnumerableRel)seed, pref);
        EnumerableRel.Result iterationResult = implementor.visitChild(this, 1, (EnumerableRel)iteration, pref);
        Expression seedExp = builder.append("seed", seedResult.block);
        Expression iterativeExp = builder.append("iteration", iterationResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(seedResult.format));
        MethodCallExpression unionExp = Expressions.call(BuiltInMethod.REPEAT_UNION.method, seedExp, iterativeExp, Expressions.constant(this.iterationLimit, Integer.TYPE), Expressions.constant(this.all, Boolean.TYPE), Util.first(physType.comparer(), Expressions.call(BuiltInMethod.IDENTITY_COMPARER.method, new Expression[0])), cleanUpFunctionExp);
        builder.add(unionExp);
        return implementor.result(physType, builder.toBlock());
    }
}

